/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.item.util.NativeStackException;

public abstract class ItemStackUtil {
    private ItemStackUtil() {
    }

    public static net.minecraft.world.item.ItemStack toNative(@Nullable ItemStack stack) {
        if (stack instanceof net.minecraft.world.item.ItemStack || stack == null) {
            return stack == null ? ItemStackUtil.emptyNative() : (net.minecraft.world.item.ItemStack)stack;
        }
        throw new NativeStackException("The supplied item stack was not native to the current platform");
    }

    public static net.minecraft.world.item.ItemStack[] toNative(List<ItemStack> items) {
        return (net.minecraft.world.item.ItemStack[])items.stream().map(ItemStackUtil::toNative).toArray(net.minecraft.world.item.ItemStack[]::new);
    }

    public static net.minecraft.world.item.ItemStack[] fromSnapshotToNative(List<ItemStackSnapshot> items) {
        return (net.minecraft.world.item.ItemStack[])items.stream().map(ItemStackUtil::fromSnapshotToNative).toArray(net.minecraft.world.item.ItemStack[]::new);
    }

    public static ItemStack fromNative(net.minecraft.world.item.ItemStack stack) {
        if (stack instanceof ItemStack) {
            return (ItemStack)stack;
        }
        throw new NativeStackException("The supplied native item stack was not compatible with the target environment");
    }

    public static List<ItemStack> fromNative(net.minecraft.world.item.ItemStack[] items) {
        return Arrays.stream(items).map(ItemStackUtil::fromNative).collect(Collectors.toList());
    }

    public static net.minecraft.world.item.ItemStack cloneDefensiveNative(net.minecraft.world.item.ItemStack stack) {
        return stack.copy();
    }

    public static net.minecraft.world.item.ItemStack cloneDefensiveNative(net.minecraft.world.item.ItemStack stack, int newSize) {
        net.minecraft.world.item.ItemStack clone = stack.copy();
        if (!clone.isEmpty()) {
            clone.setCount(newSize);
        }
        return clone;
    }

    public static ItemStack cloneDefensive(net.minecraft.world.item.ItemStack stack) {
        return (ItemStack)ItemStackUtil.cloneDefensiveNative(stack);
    }

    public static ItemStack cloneDefensive(@Nullable ItemStack stack) {
        return ItemStackUtil.cloneDefensive(ItemStackUtil.toNative(stack));
    }

    public static ItemStack cloneDefensive(net.minecraft.world.item.ItemStack stack, int newSize) {
        return (ItemStack)ItemStackUtil.cloneDefensiveNative(stack, newSize);
    }

    public static ItemStack cloneDefensive(@Nullable ItemStack stack, int newSize) {
        return ItemStackUtil.cloneDefensive(ItemStackUtil.toNative(stack), newSize);
    }

    public static Optional<ItemStack> cloneDefensiveOptional(net.minecraft.world.item.ItemStack stack) {
        return Optional.of(ItemStackUtil.cloneDefensive(stack));
    }

    public static Optional<ItemStack> cloneDefensiveOptional(net.minecraft.world.item.ItemStack stack, int withdraw) {
        return Optional.of(ItemStackUtil.cloneDefensive(stack));
    }

    public static boolean compareIgnoreQuantity(net.minecraft.world.item.ItemStack stack1, net.minecraft.world.item.ItemStack stack2) {
        return stack1.sameItem(stack2) && net.minecraft.world.item.ItemStack.tagMatches((net.minecraft.world.item.ItemStack)stack1, (net.minecraft.world.item.ItemStack)stack2);
    }

    public static boolean compareIgnoreQuantity(net.minecraft.world.item.ItemStack stack1, ItemStack stack2) {
        return ItemStackUtil.compareIgnoreQuantity(stack1, ItemStackUtil.toNative(stack2));
    }

    public static boolean compareIgnoreQuantity(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtil.compareIgnoreQuantity(ItemStackUtil.toNative(stack1), ItemStackUtil.toNative(stack2));
    }

    public static boolean compareIgnoreQuantity(ItemStack stack1, net.minecraft.world.item.ItemStack stack2) {
        return ItemStackUtil.compareIgnoreQuantity(ItemStackUtil.toNative(stack1), stack2);
    }

    public static ItemStackSnapshot snapshotOf(net.minecraft.world.item.ItemStack itemStack) {
        return itemStack.isEmpty() ? ItemStackSnapshot.empty() : ItemStackUtil.fromNative(itemStack).createSnapshot();
    }

    public static ItemStackSnapshot snapshotOf(@Nullable ItemStack itemStack) {
        return itemStack == null ? ItemStackSnapshot.empty() : (itemStack.isEmpty() ? ItemStackSnapshot.empty() : itemStack.createSnapshot());
    }

    public static net.minecraft.world.item.ItemStack fromSnapshotToNative(@Nullable ItemStackSnapshot snapshot) {
        return snapshot == null ? ItemStackUtil.emptyNative() : (snapshot == ItemStackSnapshot.empty() ? ItemStackUtil.emptyNative() : ItemStackUtil.toNative(snapshot.createStack()));
    }

    public static ItemStack fromSnapshot(@Nullable ItemStackSnapshot snapshot) {
        return snapshot == null ? ItemStackUtil.empty() : (snapshot.isEmpty() ? ItemStackUtil.empty() : snapshot.createStack());
    }

    public static ItemStack empty() {
        return ItemStackUtil.fromNative(net.minecraft.world.item.ItemStack.EMPTY);
    }

    public static net.minecraft.world.item.ItemStack emptyNative() {
        return net.minecraft.world.item.ItemStack.EMPTY;
    }
}

