/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.client.multiplayer;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.client.ClientPlayer;
import org.spongepowered.api.world.client.ClientWorld;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin_API
implements ClientWorld {
    @Shadow
    @Final
    private Int2ObjectMap<net.minecraft.world.entity.Entity> entitiesById;
    @Shadow
    @Final
    private List<AbstractClientPlayer> players;

    @Override
    public boolean isLoaded() {
        return Minecraft.getInstance().level == this;
    }

    @Override
    public ChunkLayout chunkLayout() {
        return SpongeChunkLayout.INSTANCE;
    }

    @Override
    public Optional<Entity> entity(UUID uuid) {
        return this.entitiesById.values().stream().filter(x -> x.getUUID().equals(uuid)).findFirst();
    }

    public Collection<Entity> entities() {
        return (Collection)ImmutableList.copyOf((Collection)this.entitiesById.values());
    }

    @Override
    public Collection<? extends ClientPlayer> players() {
        return new ArrayList<AbstractClientPlayer>(this.players);
    }
}

