/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.packs;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.resource.Resource;
import org.spongepowered.api.resource.ResourcePath;
import org.spongepowered.api.resource.pack.PackContents;
import org.spongepowered.api.resource.pack.PackType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.resource.SpongeResource;
import org.spongepowered.common.resource.SpongeResourcePath;

@Mixin(value={PackResources.class})
public interface PackResourcesMixin_API
extends PackContents {
    @Shadow
    public String shadow$getName();

    @Shadow
    public InputStream shadow$getResource(net.minecraft.server.packs.PackType var1, ResourceLocation var2) throws IOException;

    @Shadow
    public boolean shadow$hasResource(net.minecraft.server.packs.PackType var1, ResourceLocation var2);

    @Shadow
    public Collection<ResourceLocation> shadow$getResources(net.minecraft.server.packs.PackType var1, String var2, String var3, int var4, Predicate<String> var5);

    @Shadow
    public Set<String> shadow$getNamespaces(net.minecraft.server.packs.PackType var1);

    @Override
    default public String name() {
        return this.shadow$getName();
    }

    @Override
    default public Optional<Resource> resource(PackType root, ResourcePath path) throws IOException {
        return Optional.ofNullable(this.api$createResource(root, path));
    }

    @Override
    default public Resource requireResource(PackType root, ResourcePath path) throws IOException {
        Resource resource = this.api$createResource(root, path);
        if (resource == null) {
            throw new NoSuchElementException(MessageFormat.format("Pack type {} does not contain a resource at {}", root, path));
        }
        return resource;
    }

    default public @Nullable Resource api$createResource(PackType root, ResourcePath path) throws IOException {
        return new SpongeResource(Objects.requireNonNull(path, "path"), this.shadow$getResource((net.minecraft.server.packs.PackType)Objects.requireNonNull(root, "root"), (ResourceLocation)path.key()));
    }

    @Override
    default public Collection<ResourcePath> paths(PackType root, String namespace, String prefix, int depth, Predicate<String> filter) {
        Collection<ResourceLocation> resources = this.shadow$getResources((net.minecraft.server.packs.PackType)Objects.requireNonNull(root, "root"), Objects.requireNonNull(namespace, "namespace"), Objects.requireNonNull(prefix, "prefix"), depth, Objects.requireNonNull(filter, "filter"));
        return resources.stream().map(r -> new SpongeResourcePath((ResourceKey)r)).collect(Collectors.toList());
    }

    @Override
    default public boolean exists(PackType root, ResourcePath path) {
        return this.shadow$hasResource((net.minecraft.server.packs.PackType)Objects.requireNonNull(root, "root"), (ResourceLocation)Objects.requireNonNull(path, "path").key());
    }

    @Override
    default public Set<String> namespaces(PackType root) {
        return this.shadow$getNamespaces((net.minecraft.server.packs.PackType)Objects.requireNonNull(root, "root"));
    }
}

