/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.item.ItemRarity;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.tag.TagType;
import org.spongepowered.api.tag.TagTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.util.TagUtil;

@Mixin(value={Item.class})
public abstract class ItemMixin_API
implements ItemType,
SpongeImmutableDataHolder<ItemType> {
    @Shadow
    @Final
    private Rarity rarity;
    @Nullable
    protected BlockType api$blockType = null;

    @Shadow
    public abstract int shadow$getMaxStackSize();

    @Shadow
    public abstract String shadow$getDescriptionId();

    @Shadow
    @Nullable
    public abstract Item shadow$getCraftingRemainingItem();

    public Component asComponent() {
        return Component.translatable((String)this.shadow$getDescriptionId());
    }

    @Override
    public int maxStackQuantity() {
        return this.shadow$getMaxStackSize();
    }

    @Override
    public ItemRarity rarity() {
        return (ItemRarity)this.rarity;
    }

    @Override
    public Optional<BlockType> block() {
        return Optional.ofNullable(this.api$blockType);
    }

    @Override
    public boolean isAnyOf(Supplier<? extends ItemType> ... types) {
        return Arrays.stream(types).map(Supplier::get).anyMatch(type -> type == this);
    }

    @Override
    public boolean isAnyOf(ItemType ... types) {
        return Arrays.stream(types).anyMatch(type -> type == this);
    }

    @Override
    public TagType<ItemType> tagType() {
        return TagTypes.ITEM_TYPE.get();
    }

    @Override
    public Collection<Tag<ItemType>> tags() {
        return TagUtil.getAssociatedTags(this, RegistryTypes.ITEM_TYPE_TAGS);
    }

    @Override
    public Optional<ItemType> container() {
        Item craftingRemainingItem = this.shadow$getCraftingRemainingItem();
        return Optional.ofNullable((ItemType)craftingRemainingItem);
    }
}

