/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import javax.annotation.Nullable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.chunk.ChunkState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.chunk.ChunkBiomeContainerAccessor;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ChunkAccess.class})
public interface ChunkAccessMixin_API<P extends Chunk<P>>
extends Chunk<P> {
    @Shadow
    public ChunkStatus shadow$getStatus();

    @Shadow
    @Nullable
    public ChunkBiomeContainer shadow$getBiomes();

    @Shadow
    public void shadow$addEntity(net.minecraft.world.entity.Entity var1);

    @Shadow
    public void shadow$setUnsaved(boolean var1);

    @Shadow
    public void shadow$setInhabitedTime(long var1);

    @Shadow
    public long shadow$getInhabitedTime();

    @Shadow
    public ChunkPos shadow$getPos();

    @Shadow
    public int shadow$getHeight(Heightmap.Types var1, int var2, int var3);

    @Override
    default public void addEntity(Entity entity) {
        this.shadow$addEntity((net.minecraft.world.entity.Entity)entity);
    }

    @Override
    default public ChunkState state() {
        return (ChunkState)this.shadow$getStatus();
    }

    @Override
    default public boolean isEmpty() {
        return this.shadow$getStatus() == ChunkStatus.EMPTY;
    }

    @Override
    default public boolean setBiome(int x, int y, int z, Biome biome) {
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> (ChunkBiomeContainerAccessor)this.shadow$getBiomes(), () -> this.shadow$setUnsaved(true));
    }

    @Override
    default public Ticks inhabitedTime() {
        return new SpongeTicks(this.shadow$getInhabitedTime());
    }

    @Override
    default public void setInhabitedTime(Ticks newInhabitedTime) {
        this.shadow$setInhabitedTime(newInhabitedTime.ticks());
    }

    @Override
    default public Vector3i chunkPosition() {
        ChunkPos chunkPos = this.shadow$getPos();
        return new Vector3i(chunkPos.x, 0, chunkPos.z);
    }

    @Override
    default public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    default public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    @Override
    default public int highestYAt(int x, int z) {
        return this.shadow$getHeight((Heightmap.Types)HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    default public int height(HeightType type, int x, int z) {
        return this.shadow$getHeight((Heightmap.Types)HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    default public ScheduledUpdateList<BlockType> scheduledBlockUpdates() {
        throw new MissingImplementationException("ChunkAccess", "scheduledBlockUpdates");
    }

    @Override
    default public ScheduledUpdateList<FluidType> scheduledFluidUpdates() {
        throw new MissingImplementationException("ChunkAccess", "scheduledFluidUpdates");
    }
}

