/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.storage;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.storage.ServerLevelData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.trader.WanderingTrader;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.api.world.weather.WeatherTypes;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.weather.SpongeWeather;
import org.spongepowered.common.world.weather.SpongeWeatherType;

@Mixin(value={ServerLevelData.class})
@Implements(value={@Interface(iface=ServerWorldProperties.class, prefix="serverWorldProperties$", remap=Interface.Remap.NONE)})
public interface ServerLevelDataMixin_API
extends ServerWorldProperties {
    @Shadow
    public void shadow$setThundering(boolean var1);

    @Shadow
    public int shadow$getRainTime();

    @Shadow
    public void shadow$setRainTime(int var1);

    @Shadow
    public void shadow$setThunderTime(int var1);

    @Shadow
    public int shadow$getThunderTime();

    @Shadow
    public int shadow$getClearWeatherTime();

    @Shadow
    public void shadow$setClearWeatherTime(int var1);

    @Shadow
    public int shadow$getWanderingTraderSpawnDelay();

    @Shadow
    public void shadow$setWanderingTraderSpawnDelay(int var1);

    @Shadow
    public int shadow$getWanderingTraderSpawnChance();

    @Shadow
    public void shadow$setWanderingTraderSpawnChance(int var1);

    @Shadow
    public void shadow$setWanderingTraderId(UUID var1);

    @Shadow
    public GameType shadow$getGameType();

    @Shadow
    public WorldBorder.Settings shadow$getWorldBorder();

    @Shadow
    public boolean shadow$isInitialized();

    @Shadow
    public boolean shadow$getAllowCommands();

    @Shadow
    public void shadow$setGameType(GameType var1);

    @Shadow
    public void shadow$setDayTime(long var1);

    @Override
    default public void setDayTime(MinecraftDayTime dayTime) {
        this.shadow$setDayTime(dayTime.asTicks().ticks());
    }

    @Override
    default public GameMode gameMode() {
        return (GameMode)this.shadow$getGameType();
    }

    @Override
    default public void setGameMode(GameMode gamemode) {
        this.shadow$setGameType((GameType)gamemode);
    }

    @Override
    default public boolean commands() {
        return this.shadow$getAllowCommands();
    }

    @Intrinsic
    default public boolean serverWorldProperties$initialized() {
        return this.shadow$isInitialized();
    }

    @Override
    default public Ticks wanderingTraderSpawnDelay() {
        return Ticks.of(this.shadow$getWanderingTraderSpawnDelay());
    }

    @Override
    default public void setWanderingTraderSpawnDelay(Ticks delay) {
        this.shadow$setWanderingTraderSpawnDelay((int)delay.ticks());
    }

    @Override
    default public int wanderingTraderSpawnChance() {
        return this.shadow$getWanderingTraderSpawnChance();
    }

    @Override
    default public void setWanderingTraderSpawnChance(int chance) {
        this.shadow$setWanderingTraderSpawnChance(chance);
    }

    @Override
    default public void setWanderingTrader(@Nullable WanderingTrader trader) {
        this.shadow$setWanderingTraderId(trader == null ? null : trader.uniqueId());
    }

    @Override
    default public Weather weather() {
        if (((ServerLevelData)this).isThundering()) {
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.THUNDER.get(), new SpongeTicks(this.shadow$getThunderTime()), new SpongeTicks(6000 - this.shadow$getThunderTime()));
        }
        if (((ServerLevelData)this).isRaining()) {
            return new SpongeWeather((SpongeWeatherType)WeatherTypes.RAIN.get(), new SpongeTicks(this.shadow$getRainTime()), new SpongeTicks(6000 - this.shadow$getRainTime()));
        }
        return new SpongeWeather((SpongeWeatherType)WeatherTypes.CLEAR.get(), new SpongeTicks(this.shadow$getClearWeatherTime()), new SpongeTicks(6000 - this.shadow$getClearWeatherTime()));
    }

    @Override
    default public void setWeather(WeatherType type) {
        this.setWeather(Objects.requireNonNull(type, "type"), new SpongeTicks(120L));
    }

    @Override
    default public void setWeather(WeatherType type, Ticks ticks) {
        Objects.requireNonNull(type, "type");
        long time = Objects.requireNonNull(ticks, "ticks").ticks();
        if (type == WeatherTypes.CLEAR.get()) {
            this.shadow$setClearWeatherTime((int)time);
            ((ServerLevelData)this).setRaining(false);
            this.shadow$setRainTime(0);
            this.shadow$setThundering(false);
            this.shadow$setThunderTime(0);
        } else if (type == WeatherTypes.RAIN.get()) {
            ((ServerLevelData)this).setRaining(true);
            this.shadow$setRainTime((int)time);
            this.shadow$setThundering(false);
            this.shadow$setThunderTime(0);
            this.shadow$setClearWeatherTime(0);
        } else if (type == WeatherTypes.THUNDER.get()) {
            ((ServerLevelData)this).setRaining(true);
            this.shadow$setRainTime((int)time);
            this.shadow$setThundering(true);
            this.shadow$setThunderTime((int)time);
            this.shadow$setClearWeatherTime(0);
        }
    }

    @Override
    default public WorldBorder worldBorder() {
        return (WorldBorder)this.shadow$getWorldBorder();
    }
}

