/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.scores;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.scores.PlayerTeamBridge;

@Mixin(value={PlayerTeam.class})
@Implements(value={@Interface(iface=Team.class, prefix="team$", remap=Interface.Remap.NONE)})
public abstract class PlayerTeamMixin_API
implements Team {
    @Nullable
    @Shadow
    @Final
    @Mutable
    private net.minecraft.world.scores.Scoreboard scoreboard;
    @Shadow
    @Final
    private String name;
    @Shadow
    @Final
    private Set<String> players;

    @Shadow
    public abstract void shadow$setAllowFriendlyFire(boolean var1);

    @Shadow
    public abstract void shadow$setSeeFriendlyInvisibles(boolean var1);

    @Shadow
    public abstract void shadow$setNameTagVisibility(Team.Visibility var1);

    @Shadow
    public abstract void shadow$setDeathMessageVisibility(Team.Visibility var1);

    @Shadow
    public abstract void shadow$setCollisionRule(Team.CollisionRule var1);

    @Shadow
    public abstract void shadow$setDisplayName(Component var1);

    @Shadow
    public abstract boolean shadow$isAllowFriendlyFire();

    @Shadow
    public abstract boolean shadow$canSeeFriendlyInvisibles();

    @Shadow
    public abstract Team.Visibility shadow$getNameTagVisibility();

    @Shadow
    public abstract Team.Visibility shadow$getDeathMessageVisibility();

    @Shadow
    public abstract Team.CollisionRule shadow$getCollisionRule();

    @Shadow
    public abstract Collection<String> shadow$getPlayers();

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public net.kyori.adventure.text.Component displayName() {
        return ((PlayerTeamBridge)((Object)this)).bridge$getDisplayName();
    }

    @Override
    public void setDisplayName(net.kyori.adventure.text.Component text) {
        ((PlayerTeamBridge)((Object)this)).bridge$setDisplayName(text);
    }

    @Override
    public NamedTextColor color() {
        return ((PlayerTeamBridge)((Object)this)).bridge$getColor();
    }

    @Override
    public void setColor(NamedTextColor color) {
        ((PlayerTeamBridge)((Object)this)).bridge$setColor(color);
    }

    @Override
    public net.kyori.adventure.text.Component prefix() {
        return ((PlayerTeamBridge)((Object)this)).bridge$getPrefix();
    }

    @Override
    public void setPrefix(net.kyori.adventure.text.Component prefix) {
        ((PlayerTeamBridge)((Object)this)).bridge$setPrefix(prefix);
    }

    @Override
    public net.kyori.adventure.text.Component suffix() {
        return ((PlayerTeamBridge)((Object)this)).bridge$getSuffix();
    }

    @Override
    public void setSuffix(net.kyori.adventure.text.Component suffix) {
        ((PlayerTeamBridge)((Object)this)).bridge$setSuffix(suffix);
    }

    @Override
    public boolean allowFriendlyFire() {
        return this.shadow$isAllowFriendlyFire();
    }

    @Intrinsic
    public void team$setAllowFriendlyFire(boolean allowFriendlyFire) {
        this.shadow$setAllowFriendlyFire(allowFriendlyFire);
    }

    @Intrinsic
    public boolean team$canSeeFriendlyInvisibles() {
        return this.shadow$canSeeFriendlyInvisibles();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) {
        this.shadow$setSeeFriendlyInvisibles(enabled);
    }

    @Override
    public Visibility nameTagVisibility() {
        return (Visibility)this.shadow$getNameTagVisibility();
    }

    @Override
    public void setNameTagVisibility(Visibility visibility) {
        this.shadow$setNameTagVisibility((Team.Visibility)visibility);
    }

    @Override
    public Visibility deathMessageVisibility() {
        return (Visibility)this.shadow$getDeathMessageVisibility();
    }

    @Override
    public void setDeathMessageVisibility(Visibility visibility) {
        this.shadow$setDeathMessageVisibility((Team.Visibility)visibility);
    }

    @Override
    public CollisionRule collisionRule() {
        return (CollisionRule)this.shadow$getCollisionRule();
    }

    @Override
    public void setCollisionRule(CollisionRule rule) {
        this.shadow$setCollisionRule((Team.CollisionRule)rule);
    }

    @Override
    public Set<net.kyori.adventure.text.Component> members() {
        LegacyComponentSerializer lcs = LegacyComponentSerializer.legacySection();
        return this.shadow$getPlayers().stream().map(arg_0 -> ((LegacyComponentSerializer)lcs).deserialize(arg_0)).collect(Collectors.toSet());
    }

    @Override
    public void addMember(net.kyori.adventure.text.Component member) {
        String legacyName = LegacyComponentSerializer.legacySection().serialize(member);
        if (legacyName.length() > 40) {
            throw new IllegalArgumentException(String.format("Member is %s characters long! It must be at most 40.", legacyName.length()));
        }
        if (this.scoreboard != null) {
            this.scoreboard.addPlayerToTeam(legacyName, (PlayerTeam)this);
        } else {
            this.players.add(legacyName);
        }
    }

    @Override
    public boolean removeMember(net.kyori.adventure.text.Component member) {
        String legacyName = LegacyComponentSerializer.legacySection().serialize(member);
        if (this.scoreboard != null) {
            PlayerTeam realTeam = this.scoreboard.getPlayersTeam(legacyName);
            if (realTeam == (PlayerTeam)this) {
                this.scoreboard.removePlayerFromTeam(legacyName, realTeam);
                return true;
            }
            return false;
        }
        return this.players.remove(legacyName);
    }

    @Override
    public Optional<Scoreboard> scoreboard() {
        return Optional.ofNullable((Scoreboard)this.scoreboard);
    }

    @Override
    public boolean unregister() {
        if (this.scoreboard == null) {
            return false;
        }
        this.scoreboard.removePlayerTeam((PlayerTeam)this);
        this.scoreboard = null;
        return true;
    }
}

