/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.protocol.status;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.status.ServerStatus;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.protocol.status.ServerStatusBridge;
import org.spongepowered.common.network.status.SpongeFavicon;

@Mixin(value={ServerStatus.class})
public abstract class ServerStatusMixin
implements ServerStatusBridge {
    @Shadow
    @Nullable
    private Component description;
    @Shadow
    @Nullable
    private String favicon;
    private net.kyori.adventure.text.Component impl$descriptionText = net.kyori.adventure.text.Component.empty();
    @Nullable
    private ServerStatus.Players impl$playerBackup;
    @Nullable
    private Favicon impl$faviconHandle;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$initializeDescriptionText(CallbackInfo ci) {
        this.setDescription(null);
    }

    @Overwrite
    public void setDescription(@Nullable Component motd) {
        if (motd != null) {
            this.description = motd;
            this.impl$descriptionText = SpongeAdventure.asAdventure(motd);
        } else {
            this.description = new TextComponent("");
            this.impl$descriptionText = net.kyori.adventure.text.Component.empty();
        }
    }

    @Overwrite
    public void setFavicon(@Nullable String faviconBlob) {
        if (faviconBlob == null) {
            this.favicon = null;
            this.impl$faviconHandle = null;
        } else {
            try {
                this.impl$faviconHandle = new SpongeFavicon(faviconBlob);
                this.favicon = faviconBlob;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public net.kyori.adventure.text.Component bridge$getDescription() {
        return this.impl$descriptionText;
    }

    @Override
    public void bridge$setDescription(@Nullable net.kyori.adventure.text.Component text) {
        this.impl$descriptionText = text == null ? net.kyori.adventure.text.Component.empty() : text;
    }

    @Override
    public Favicon bridge$getFavicon() {
        return this.impl$faviconHandle;
    }

    @Override
    public void setFavicon(@Nullable Favicon favicon) {
        this.impl$faviconHandle = favicon;
        this.favicon = favicon != null ? ((SpongeFavicon)favicon).getEncoded() : null;
    }

    @Override
    public ServerStatus.Players bridge$getPlayerBackup() {
        return this.impl$playerBackup;
    }

    @Override
    public void bridge$setPlayerBackup(ServerStatus.Players players) {
        this.impl$playerBackup = players;
    }
}

