/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.bridge.server.network.ServerLoginPacketListenerImplBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.network.channel.SpongeChannelManager;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin
implements ServerLoginPacketListenerImplBridge,
ConnectionHolderBridge {
    @Shadow
    @Final
    public Connection connection;
    @Shadow
    private GameProfile gameProfile;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    private ServerLoginPacketListenerImpl.State state;
    @Shadow
    private ServerPlayer delayedAcceptPlayer;
    private boolean impl$accepted = false;

    @Shadow
    protected abstract GameProfile shadow$createFakeProfile(GameProfile var1);

    @Shadow
    public abstract void shadow$disconnect(net.minecraft.network.chat.Component var1);

    @Shadow
    public abstract void disconnect(net.minecraft.network.chat.Component var1);

    @Override
    public Connection bridge$getConnection() {
        return this.connection;
    }

    @Overwrite
    public void handleAcceptedLogin() {
        if (!this.gameProfile.isComplete()) {
            this.gameProfile = this.shadow$createFakeProfile(this.gameProfile);
        }
        if (this.impl$accepted) {
            return;
        }
        this.impl$accepted = true;
        PlayerList playerList = this.server.getPlayerList();
        ((CompletableFuture)((CompletableFuture)((PlayerListBridge)playerList).bridge$canPlayerLogin(this.connection.getRemoteAddress(), this.gameProfile).handle((componentOpt, throwable) -> {
            if (throwable != null) {
                ((ConnectionBridge)this.connection).bridge$setKickReason((net.minecraft.network.chat.Component)new net.minecraft.network.chat.TextComponent("An error occurred checking ban/whitelist status."));
                SpongeCommon.logger().error("An error occurred when checking the ban/whitelist status of {}.", (Object)this.gameProfile.getId().toString());
                SpongeCommon.logger().error(throwable);
            } else if (componentOpt != null) {
                ((ConnectionBridge)this.connection).bridge$setKickReason((net.minecraft.network.chat.Component)componentOpt);
            }
            try {
                ((SpongeServer)SpongeCommon.server()).userManager().handlePlayerLogin(this.gameProfile);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return null;
        })).handleAsync((ignored, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throw (CompletionException)throwable;
                }
                throw new CompletionException((Throwable)throwable);
            }
            this.state = ServerLoginPacketListenerImpl.State.ACCEPTED;
            if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
                this.connection.send((Packet)new ClientboundLoginCompressionPacket(this.server.getCompressionThreshold()), param0 -> this.connection.setupCompression(this.server.getCompressionThreshold()));
            }
            this.connection.send((Packet)new ClientboundGameProfilePacket(this.gameProfile));
            ServerPlayer var1 = this.server.getPlayerList().getPlayer(this.gameProfile.getId());
            if (var1 != null) {
                this.state = ServerLoginPacketListenerImpl.State.DELAY_ACCEPT;
                this.delayedAcceptPlayer = this.server.getPlayerList().getPlayerForLogin(this.gameProfile);
            } else {
                ServerSideConnection connection = (ServerSideConnection)((Object)this);
                ((SpongeChannelManager)Sponge.channelManager()).sendChannelRegistrations(connection);
                try {
                    this.server.getPlayerList().placeNewPlayer(this.connection, this.server.getPlayerList().getPlayerForLogin(this.gameProfile));
                    Sponge.server().userManager().removeFromCache(this.gameProfile.getId());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }, (Executor)SpongeCommon.server())).exceptionally(throwable -> {
            if (throwable != null) {
                this.impl$disconnectError((Throwable)throwable, this.state == ServerLoginPacketListenerImpl.State.ACCEPTED || this.state == ServerLoginPacketListenerImpl.State.READY_TO_ACCEPT);
            }
            return null;
        });
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void impl$catchErrorWhenTickingNewPlayer(PlayerList playerList, Connection param0, ServerPlayer param1) {
        try {
            playerList.placeNewPlayer(param0, param1);
        }
        catch (Exception e) {
            this.impl$disconnectError(e, true);
        }
    }

    private void impl$disconnectError(Throwable throwable, boolean gameDisconnect) {
        SpongeCommon.logger().error("Forcibly disconnecting user {} due to an error during login.", (Object)this.gameProfile, (Object)throwable);
        net.minecraft.network.chat.TextComponent message = new net.minecraft.network.chat.TextComponent("Internal Server Error: unable to complete login.");
        if (gameDisconnect) {
            this.connection.send((Packet)new ClientboundDisconnectPacket((net.minecraft.network.chat.Component)message), arg_0 -> this.lambda$impl$disconnectError$4((net.minecraft.network.chat.Component)message, arg_0));
        } else {
            this.shadow$disconnect((net.minecraft.network.chat.Component)message);
        }
    }

    private void impl$disconnectClient(Component disconnectMessage) {
        net.minecraft.network.chat.Component reason = SpongeAdventure.asVanilla(disconnectMessage);
        this.shadow$disconnect(reason);
    }

    @Override
    public boolean bridge$fireAuthEvent() {
        TextComponent disconnectMessage = Component.text((String)"You are not allowed to log in to this server.");
        Cause cause = Cause.of(EventContext.empty(), this);
        ServerSideConnectionEvent.Auth event = SpongeEventFactory.createServerSideConnectionEventAuth(cause, (Component)disconnectMessage, (Component)disconnectMessage, (ServerSideConnection)((Object)this));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            this.impl$disconnectClient(event.message());
        }
        return event.isCancelled();
    }

    @Inject(method={"handleHello(Lnet/minecraft/network/protocol/login/ServerboundHelloPacket;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerLoginPacketListenerImpl;state:Lnet/minecraft/server/network/ServerLoginPacketListenerImpl$State;", opcode=181, ordinal=1)}, cancellable=true)
    private void impl$fireAuthEventOffline(CallbackInfo ci) {
        if (!this.gameProfile.isComplete()) {
            this.gameProfile = this.shadow$createFakeProfile(this.gameProfile);
        }
        if (this.bridge$fireAuthEvent()) {
            ci.cancel();
        }
    }

    private /* synthetic */ void lambda$impl$disconnectError$4(net.minecraft.network.chat.Component message, Future param1) throws Exception {
        this.connection.disconnect(message);
    }
}

