/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.players;

import com.mojang.authlib.GameProfile;
import io.netty.channel.local.LocalAddress;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.adventure.Audiences;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundPlayerInfoPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.client.server.IntegratedPlayerListBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.entity.player.SpongeUserView;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.effect.BroadcastInventoryChangesEffect;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.server.PerWorldBorderListener;
import org.spongepowered.common.service.server.ban.SpongeIPBanList;
import org.spongepowered.common.service.server.ban.SpongeUserBanList;
import org.spongepowered.common.service.server.whitelist.SpongeUserWhiteList;
import org.spongepowered.common.util.NetworkUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private static SimpleDateFormat BAN_DATE_FORMAT;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    private int viewDistance;
    @Shadow
    @Final
    @Mutable
    private UserBanList bans;
    @Shadow
    @Final
    @Mutable
    private IpBanList ipBans;
    @Shadow
    @Final
    @Mutable
    private UserWhiteList whitelist;
    @Shadow
    @Final
    private List<net.minecraft.server.level.ServerPlayer> players;
    @Shadow
    @Final
    protected int maxPlayers;
    @Shadow
    @Final
    private Map<UUID, net.minecraft.server.level.ServerPlayer> playersByUUID;
    private boolean impl$isGameMechanicRespawn = false;
    private ResourceKey<Level> impl$originalRespawnDestination = null;

    @Shadow
    public abstract MinecraftServer shadow$getServer();

    @Shadow
    @Nullable
    public abstract CompoundTag shadow$load(net.minecraft.server.level.ServerPlayer var1);

    @Shadow
    public abstract boolean shadow$canBypassPlayerLimit(GameProfile var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setSpongeLists(CallbackInfo callbackInfo) {
        this.bans = new SpongeUserBanList(PlayerList.USERBANLIST_FILE);
        this.ipBans = new SpongeIPBanList(PlayerList.IPBANLIST_FILE);
        this.whitelist = new SpongeUserWhiteList(PlayerList.WHITELIST_FILE);
    }

    @Override
    public CompletableFuture<net.minecraft.network.chat.Component> bridge$canPlayerLogin(SocketAddress param0, GameProfile param1) {
        if (this instanceof IntegratedPlayerListBridge) {
            return ((IntegratedPlayerListBridge)((Object)this)).bridge$canPlayerLoginClient(param0, param1);
        }
        return this.impl$canPlayerLoginServer(param0, param1);
    }

    protected final CompletableFuture<net.minecraft.network.chat.Component> impl$canPlayerLoginServer(SocketAddress param0, GameProfile param1) {
        SpongeGameProfile profile = SpongeGameProfile.basicOf(param1);
        return ((CompletableFuture)Sponge.server().serviceProvider().banService().find(profile).thenCompose(profileBanOpt -> {
            InetAddress address;
            if (profileBanOpt.isPresent()) {
                Ban.Profile var0 = (Ban.Profile)profileBanOpt.get();
                TranslatableComponent var1 = new TranslatableComponent("multiplayer.disconnect.banned.reason", new Object[]{var0.reason().orElse((Component)Component.empty())});
                if (var0.expirationDate().isPresent()) {
                    Date date = Date.from(var0.expirationDate().get());
                    var1.append((net.minecraft.network.chat.Component)new TranslatableComponent("multiplayer.disconnect.banned.expiration", new Object[]{BAN_DATE_FORMAT.format(date)}));
                }
                return CompletableFuture.completedFuture(var1);
            }
            if (param0 instanceof LocalAddress) {
                return CompletableFuture.completedFuture(null);
            }
            try {
                address = InetAddress.getByName(NetworkUtil.getHostString(param0));
            }
            catch (UnknownHostException ex) {
                return CompletableFuture.completedFuture(new TextComponent(ex.getMessage()));
            }
            return Sponge.server().serviceProvider().banService().find(address).thenCompose(ipBanOpt -> {
                if (ipBanOpt.isPresent()) {
                    Ban.IP var2 = (Ban.IP)ipBanOpt.get();
                    TranslatableComponent var3 = new TranslatableComponent("multiplayer.disconnect.banned_ip.reason", new Object[]{var2.reason().orElse((Component)Component.empty())});
                    if (var2.expirationDate().isPresent()) {
                        Date date = Date.from(var2.expirationDate().get());
                        var3.append((net.minecraft.network.chat.Component)new TranslatableComponent("multiplayer.disconnect.banned_ip.expiration", new Object[]{BAN_DATE_FORMAT.format(date)}));
                    }
                    return CompletableFuture.completedFuture(var3);
                }
                return CompletableFuture.supplyAsync(() -> {
                    if (!Sponge.server().isWhitelistEnabled()) {
                        return true;
                    }
                    PermissionService permissionService = Sponge.server().serviceProvider().permissionService();
                    Subject subject = permissionService.userSubjects().subject(param1.getId().toString()).orElse(null);
                    if (subject == null) {
                        subject = permissionService.defaults();
                    }
                    return subject.hasPermission("minecraft.login.bypass-whitelist");
                }, (Executor)SpongeCommon.server()).thenCompose(w -> {
                    if (w.booleanValue()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return Sponge.server().serviceProvider().whitelistService().isWhitelisted(profile).thenApply(whitelisted -> {
                        if (!whitelisted.booleanValue()) {
                            return new TranslatableComponent("multiplayer.disconnect.not_whitelisted");
                        }
                        return null;
                    });
                });
            });
        })).thenApplyAsync(component -> {
            if (component != null) {
                return component;
            }
            if (this.players.size() >= this.maxPlayers && !this.shadow$canBypassPlayerLimit(param1)) {
                return new TranslatableComponent("multiplayer.disconnect.server_full");
            }
            return null;
        }, (Executor)SpongeCommon.server());
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;load(Lnet/minecraft/server/level/ServerPlayer;)Lnet/minecraft/nbt/CompoundTag;"))
    private CompoundTag impl$setPlayerDataForNewPlayers(PlayerList playerList, net.minecraft.server.level.ServerPlayer playerIn) {
        CompoundTag compound = this.shadow$load(playerIn);
        if (compound == null) {
            ((SpongeServer)SpongeCommon.server()).getPlayerDataManager().setPlayerInfo(playerIn.getUUID(), Instant.now(), Instant.now());
        }
        return compound;
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getLevel(Lnet/minecraft/resources/ResourceKey;)Lnet/minecraft/server/level/ServerLevel;"))
    private ServerLevel impl$onInitPlayer_getWorld(MinecraftServer minecraftServer, ResourceKey<Level> dimension, Connection networkManager, net.minecraft.server.level.ServerPlayer mcPlayer) {
        net.minecraft.network.chat.Component kickReason = ((ConnectionBridge)networkManager).bridge$getKickReason();
        Object disconnectMessage = kickReason != null ? SpongeAdventure.asAdventure(kickReason) : Component.text((String)"You are not allowed to log in to this server.");
        ServerLevel mcWorld = minecraftServer.getLevel(dimension);
        if (mcWorld == null) {
            SpongeCommon.logger().warn("The player '{}' was located in a world that isn't loaded or doesn't exist. This is not safe so the player will be moved to the spawn of the default world.", (Object)mcPlayer.getGameProfile().getName());
            mcWorld = minecraftServer.overworld();
            BlockPos spawnPoint = mcWorld.getSharedSpawnPos();
            mcPlayer.setPos((double)spawnPoint.getX() + 0.5, (double)spawnPoint.getY() + 0.5, (double)spawnPoint.getZ() + 0.5);
        }
        mcPlayer.setLevel((Level)mcWorld);
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerLocation location = player.serverLocation();
        Vector3d rotation = player.rotation();
        ServerSideConnection connection = (ServerSideConnection)networkManager.getPacketListener();
        User user = SpongeUserView.createLoginEventUser(player);
        Cause cause = Cause.of(EventContext.empty(), connection, user);
        ServerSideConnectionEvent.Login event = SpongeEventFactory.createServerSideConnectionEventLogin(cause, disconnectMessage, disconnectMessage, location, location, rotation, rotation, connection, user);
        if (kickReason != null) {
            event.setCancelled(true);
        }
        if (SpongeCommon.post(event)) {
            this.impl$disconnectClient(networkManager, event.message(), player.profile());
            return null;
        }
        ServerLocation toLocation = event.toLocation();
        Vector3d toRotation = event.toRotation();
        mcPlayer.absMoveTo(toLocation.x(), toLocation.y(), toLocation.z(), (float)toRotation.y(), (float)toRotation.x());
        return (ServerLevel)toLocation.world();
    }

    @Inject(method={"placeNewPlayer"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getLevel(Lnet/minecraft/resources/ResourceKey;)Lnet/minecraft/server/level/ServerLevel;", shift=At.Shift.AFTER)})
    private void impl$onInitPlayer_BeforeSetWorld(Connection p_72355_1_, net.minecraft.server.level.ServerPlayer p_72355_2_, CallbackInfo ci) {
        if (!p_72355_1_.isConnected()) {
            ci.cancel();
        }
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;info(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", remap=false))
    private void impl$onInitPlayer_printPlayerWorldInJoinFeedback(Logger logger, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Connection manager, net.minecraft.server.level.ServerPlayer entity) {
        logger.info("{}[{}] logged in to world '{}' with entity id {} at ({}, {}, {})", p0, p1, (Object)((ServerWorld)entity.getLevel()).key(), p2, p3, p4, p5);
    }

    @Redirect(method={"placeNewPlayer"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;invalidateStatus()V"), to=@At(value="FIELD", opcode=178, target="Lnet/minecraft/ChatFormatting;YELLOW:Lnet/minecraft/ChatFormatting;")), at=@At(value="INVOKE", remap=false, target="Ljava/lang/String;equalsIgnoreCase(Ljava/lang/String;)Z"))
    private boolean impl$onInitPlayer_dontClassSpongeNameAsModified(String currentName, String originalName) {
        if (originalName.equals("[sponge]")) {
            return true;
        }
        return currentName.equalsIgnoreCase(originalName);
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/ChatType;Ljava/util/UUID;)V"))
    private void impl$onInitPlayer_delaySendMessage(PlayerList playerList, net.minecraft.network.chat.Component message, ChatType p_232641_2_, UUID p_232641_3_, Connection manager, net.minecraft.server.level.ServerPlayer playerIn) {
        ((ServerPlayerBridge)playerIn).bridge$setConnectionMessageToSend(message);
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="NEW", target="net/minecraft/network/protocol/game/ClientboundLoginPacket"))
    private ClientboundLoginPacket impl$usePerWorldViewDistance(int p_i242082_1_, GameType p_i242082_2_, GameType p_i242082_3_, long p_i242082_4_, boolean p_i242082_6_, Set<ResourceKey<Level>> p_i242082_7_, RegistryAccess.RegistryHolder p_i242082_8_, DimensionType p_i242082_9_, ResourceKey<Level> p_i242082_10_, int p_i242082_11_, int p_i242082_12_, boolean p_i242082_13_, boolean p_i242082_14_, boolean p_i242082_15_, boolean p_i242082_16_, Connection p_72355_1_, net.minecraft.server.level.ServerPlayer player) {
        return new ClientboundLoginPacket(p_i242082_1_, p_i242082_2_, p_i242082_3_, p_i242082_4_, p_i242082_6_, p_i242082_7_, p_i242082_8_, p_i242082_9_, p_i242082_10_, p_i242082_11_, ((PrimaryLevelDataBridge)player.getLevel().getLevelData()).bridge$viewDistance().orElse(this.viewDistance).intValue(), p_i242082_13_, p_i242082_14_, p_i242082_15_, p_i242082_16_);
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCustomBossEvents()Lnet/minecraft/server/bossevents/CustomBossEvents;"))
    private CustomBossEvents impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, Connection netManager, net.minecraft.server.level.ServerPlayer playerIn) {
        return ((ServerLevelBridge)playerIn.getLevel()).bridge$getBossBarManager();
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;updateEntireScoreboard(Lnet/minecraft/server/ServerScoreboard;Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void impl$sendScoreboard(PlayerList playerList, ServerScoreboard scoreboardIn, net.minecraft.server.level.ServerPlayer playerIn) {
        ((ServerPlayerBridge)playerIn).bridge$initScoreboard();
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V"))
    private void impl$sendScoreboard(PlayerList playerList, Packet<?> addPlayer, Connection playerConnection, net.minecraft.server.level.ServerPlayer serverPlayer) {
        if (((VanishableBridge)serverPlayer).bridge$vanishState().invisible()) {
            return;
        }
        playerList.broadcastAll(addPlayer);
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/List;size()I", remap=false), to=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addNewPlayer(Lnet/minecraft/server/level/ServerPlayer;)V")))
    private void impl$onlySendAddPlayerForUnvanishedPlayers(ServerGamePacketListenerImpl connection, Packet<?> packet) {
        ClientboundPlayerInfoPacketAccessor playerInfoPacketAccessor = (ClientboundPlayerInfoPacketAccessor)packet;
        VanishableBridge p = (VanishableBridge)this.playersByUUID.get(playerInfoPacketAccessor.accessor$entries().get(0).getProfile().getId());
        if (p.bridge$vanishState().invisible()) {
            return;
        }
        connection.send(packet);
    }

    @Inject(method={"placeNewPlayer"}, at={@At(value="RETURN")})
    private void impl$onInitPlayer_join(Connection networkManager, net.minecraft.server.level.ServerPlayer mcPlayer, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerPlayerConnection connection = player.connection();
        Cause cause = Cause.of(EventContext.empty(), connection, player);
        Audience audience = Audiences.onlinePlayers();
        Component joinComponent = SpongeAdventure.asAdventure(((ServerPlayerBridge)mcPlayer).bridge$getConnectionMessageToSend());
        ServerSideConnectionEvent.Join event = SpongeEventFactory.createServerSideConnectionEventJoin(cause, audience, Optional.of(audience), joinComponent, joinComponent, connection, player, false);
        SpongeCommon.post(event);
        if (!event.isMessageCancelled()) {
            event.audience().ifPresent(audience1 -> audience1.sendMessage(Identity.nil(), event.message()));
        }
        ((ServerPlayerBridge)mcPlayer).bridge$setConnectionMessageToSend(null);
        PhaseContext<?> context = PhaseTracker.SERVER.getPhaseContext();
        PhaseTracker.SERVER.pushCause(event);
        TransactionalCaptureSupplier transactor = context.getTransactor();
        transactor.logPlayerInventoryChange((Player)mcPlayer, PlayerInventoryTransaction.EventCreator.STANDARD);
        try (EffectTransactor ignored = BroadcastInventoryChangesEffect.transact(transactor);){
            mcPlayer.inventoryMenu.broadcastChanges();
        }
    }

    @Redirect(method={"remove"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCustomBossEvents()Lnet/minecraft/server/bossevents/CustomBossEvents;"))
    private CustomBossEvents impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, net.minecraft.server.level.ServerPlayer playerIn) {
        return ((ServerLevelBridge)playerIn.getLevel()).bridge$getBossBarManager();
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void impl$RemovePlayerReferenceFromScoreboard(net.minecraft.server.level.ServerPlayer player, CallbackInfo ci) {
        ((ServerScoreboardBridge)((Object)((ServerPlayer)player).scoreboard())).bridge$removePlayer(player, false);
    }

    @Redirect(method={"setLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/border/WorldBorder;addListener(Lnet/minecraft/world/level/border/BorderChangeListener;)V"))
    private void impl$usePerWorldBorderListener(WorldBorder worldBorder, BorderChangeListener listener, ServerLevel serverWorld) {
        worldBorder.addListener((BorderChangeListener)new PerWorldBorderListener(serverWorld));
    }

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;load(Lnet/minecraft/nbt/CompoundTag;)V"))
    private void impl$setSpongePlayerDataForSinglePlayer(net.minecraft.server.level.ServerPlayer entity, CompoundTag compound) {
        entity.load(compound);
        ((SpongeServer)this.shadow$getServer()).getPlayerDataManager().readPlayerData(compound, entity.getUUID(), null);
    }

    @Redirect(method={"respawn"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z", remap=false), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/Optional;empty()Ljava/util/Optional;", remap=false), to=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;isDemo()Z")))
    private boolean impl$flagIfRespawnPositionIsGameMechanic(Optional<Vec3> respawnPosition) {
        this.impl$isGameMechanicRespawn = respawnPosition.isPresent();
        return false;
    }

    @Redirect(method={"respawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;overworld()Lnet/minecraft/server/level/ServerLevel;"))
    private ServerLevel impl$callRespawnPlayerSelectWorld(MinecraftServer server, net.minecraft.server.level.ServerPlayer player) {
        ServerLevel playerRespawnDestination = server.getLevel(player.getRespawnDimension());
        ServerLevel originalDestination = playerRespawnDestination != null && this.impl$isGameMechanicRespawn ? playerRespawnDestination : server.overworld();
        this.impl$originalRespawnDestination = originalDestination.dimension();
        RespawnPlayerEvent.SelectWorld event = SpongeEventFactory.createRespawnPlayerEventSelectWorld(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)originalDestination, (ServerWorld)player.getLevel(), (ServerWorld)originalDestination, (ServerPlayer)player);
        SpongeCommon.post(event);
        return (ServerLevel)event.destinationWorld();
    }

    @Redirect(method={"respawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getX()D"), slice=@Slice(from=@At(value="NEW", target="net/minecraft/network/protocol/game/ClientboundRespawnPacket"), to=@At(value="NEW", target="net/minecraft/network/protocol/game/ClientboundSetDefaultSpawnPositionPacket")))
    private double impl$callRespawnPlayerRecreateEvent(net.minecraft.server.level.ServerPlayer newPlayer, net.minecraft.server.level.ServerPlayer player, boolean keepAllPlayerData) {
        ServerPlayer originalPlayer = (ServerPlayer)player;
        ServerPlayer recreatedPlayer = (ServerPlayer)newPlayer;
        Vector3d originalPosition = originalPlayer.position();
        Vector3d destinationPosition = recreatedPlayer.position();
        ServerWorld originalWorld = originalPlayer.world();
        ServerWorld destinationWorld = recreatedPlayer.world();
        RespawnPlayerEvent.Recreate event = SpongeEventFactory.createRespawnPlayerEventRecreate(PhaseTracker.getCauseStackManager().currentCause(), destinationPosition, originalWorld, originalPosition, destinationWorld, (ServerWorld)this.server.getLevel(this.impl$originalRespawnDestination), destinationPosition, originalPlayer, recreatedPlayer, this.impl$isGameMechanicRespawn, !keepAllPlayerData);
        SpongeCommon.post(event);
        this.impl$isGameMechanicRespawn = false;
        newPlayer.setPos(event.destinationPosition().x(), event.destinationPosition().y(), event.destinationPosition().z());
        return newPlayer.getX();
    }

    @Inject(method={"respawn"}, at={@At(value="RETURN")})
    private void impl$callRespawnPlayerPostEvent(net.minecraft.server.level.ServerPlayer player, boolean keepAllPlayerData, CallbackInfoReturnable<net.minecraft.server.level.ServerPlayer> cir) {
        ServerPlayer recreatedPlayer = (ServerPlayer)cir.getReturnValue();
        ServerWorld originalWorld = (ServerWorld)player.level;
        RespawnPlayerEvent.Post event = SpongeEventFactory.createRespawnPlayerEventPost(PhaseTracker.getCauseStackManager().currentCause(), recreatedPlayer.world(), originalWorld, (ServerWorld)this.server.getLevel(this.impl$originalRespawnDestination), recreatedPlayer);
        SpongeCommon.post(event);
        this.impl$originalRespawnDestination = null;
    }

    @Redirect(method={"sendLevelInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;overworld()Lnet/minecraft/server/level/ServerLevel;"))
    private ServerLevel impl$usePerWorldWorldBorder(MinecraftServer minecraftServer, net.minecraft.server.level.ServerPlayer playerIn, ServerLevel worldIn) {
        return worldIn;
    }

    private void impl$disconnectClient(Connection netManager, Component disconnectMessage, @Nullable org.spongepowered.api.profile.GameProfile profile) {
        net.minecraft.network.chat.Component reason = SpongeAdventure.asVanilla(disconnectMessage);
        try {
            LOGGER.info("Disconnecting " + (profile != null ? profile.toString() + " (" + netManager.getRemoteAddress().toString() + ")" : netManager.getRemoteAddress() + ": " + reason.getString()));
            netManager.send((Packet)new ClientboundDisconnectPacket(reason));
            netManager.disconnect(reason);
        }
        catch (Exception exception) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    @Inject(method={"saveAll()V"}, at={@At(value="RETURN")})
    private void impl$saveDirtyUsersOnSaveAll(CallbackInfo ci) {
        ((SpongeServer)SpongeCommon.server()).userManager().saveDirtyUsers();
    }
}

