/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import net.kyori.adventure.bossbar.BossBar;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.BossEventBridge;

@Mixin(value={BossEvent.class})
public abstract class BossEventMixin
implements BossEventBridge {
    @Shadow
    protected Component name;
    @Shadow
    protected float percent;
    @Shadow
    protected BossEvent.BossBarColor color;
    @Shadow
    protected BossEvent.BossBarOverlay overlay;
    @Shadow
    protected boolean darkenScreen;
    @Shadow
    protected boolean playBossMusic;
    @Shadow
    protected boolean createWorldFog;
    protected BossBar impl$adventure;

    @Override
    public void bridge$copyAndAssign(BossBar adventure) {
        this.impl$adventure = adventure;
        this.percent = adventure.progress();
        this.darkenScreen = adventure.hasFlag(BossBar.Flag.DARKEN_SCREEN);
        this.playBossMusic = adventure.hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        this.createWorldFog = adventure.hasFlag(BossBar.Flag.CREATE_WORLD_FOG);
    }

    @Override
    public BossBar bridge$asAdventure() {
        if (this.impl$adventure == null) {
            this.bridge$setAdventure(BossBar.bossBar((net.kyori.adventure.text.Component)SpongeAdventure.asAdventure(this.name), (float)this.percent, (BossBar.Color)SpongeAdventure.asAdventure(this.color), (BossBar.Overlay)SpongeAdventure.asAdventure(this.overlay), SpongeAdventure.asAdventureFlags(this.darkenScreen, this.playBossMusic, this.createWorldFog)));
        }
        return this.impl$adventure;
    }

    @Override
    public void bridge$setAdventure(BossBar adventure) {
        this.impl$adventure = adventure;
    }

    @Override
    public void bridge$replacePlayer(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
    }

    @Redirect(method={"setName"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;name:Lnet/minecraft/network/chat/Component;"))
    private void adventureName(BossEvent $this, Component name) {
        this.bridge$asAdventure().name(SpongeAdventure.asAdventure(name));
    }

    @Redirect(method={"setPercent"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;percent:F"))
    private void adventurePercent(BossEvent $this, float percent) {
        this.bridge$asAdventure().progress(percent);
    }

    @Redirect(method={"setColor"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;color:Lnet/minecraft/world/BossEvent$BossBarColor;"))
    private void adventureColor(BossEvent $this, BossEvent.BossBarColor color) {
        this.bridge$asAdventure().color(SpongeAdventure.asAdventure(color));
    }

    @Redirect(method={"setOverlay"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;overlay:Lnet/minecraft/world/BossEvent$BossBarOverlay;"))
    private void adventureOverlay(BossEvent $this, BossEvent.BossBarOverlay overlay) {
        this.bridge$asAdventure().overlay(SpongeAdventure.asAdventure(overlay));
    }

    @Redirect(method={"setDarkenScreen"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;darkenScreen:Z"))
    private void adventureDarkenScreen(BossEvent $this, boolean darkenScreen) {
        if (darkenScreen) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.DARKEN_SCREEN);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.DARKEN_SCREEN);
        }
    }

    @Redirect(method={"setPlayBossMusic"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;playBossMusic:Z"))
    private void adventurePlayBossMusic(BossEvent $this, boolean playBossMusic) {
        if (playBossMusic) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
    }

    @Redirect(method={"setCreateWorldFog"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;createWorldFog:Z"))
    private void adventureCreateWorldFog(BossEvent $this, boolean createWorldFog) {
        if (createWorldFog) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.CREATE_WORLD_FOG);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.CREATE_WORLD_FOG);
        }
    }

    @Redirect(method={"getName"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;name:Lnet/minecraft/network/chat/Component;"))
    private Component nameRead(BossEvent $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().name());
    }

    @Redirect(method={"getPercent"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;percent:F"))
    private float percentRead(BossEvent $this) {
        return this.bridge$asAdventure().progress();
    }

    @Redirect(method={"getColor"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;color:Lnet/minecraft/world/BossEvent$BossBarColor;"))
    private BossEvent.BossBarColor colorRead(BossEvent $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().color());
    }

    @Redirect(method={"getOverlay"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;overlay:Lnet/minecraft/world/BossEvent$BossBarOverlay;"))
    private BossEvent.BossBarOverlay overlayRead(BossEvent $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().overlay());
    }

    @Redirect(method={"shouldDarkenScreen"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;darkenScreen:Z"))
    private boolean darkenSkyRead(BossEvent $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.DARKEN_SCREEN);
    }

    @Redirect(method={"shouldPlayBossMusic"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;playBossMusic:Z"))
    private boolean playEndBossMusicRead(BossEvent $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
    }

    @Redirect(method={"shouldCreateWorldFog"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossEvent;createWorldFog:Z"))
    private boolean createFogRead(BossEvent $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.CREATE_WORLD_FOG);
    }
}

