/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level;

import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.bridge.world.level.BaseSpawnerBridge;

@Mixin(value={BaseSpawner.class})
public abstract class BaseSpawnerMixin
implements BaseSpawnerBridge {
    @Shadow
    private int spawnDelay;
    @Shadow
    private int minSpawnDelay;
    @Shadow
    private int maxSpawnDelay;
    @Shadow
    private int spawnCount;
    @Shadow
    private int maxNearbyEntities;
    @Shadow
    private int requiredPlayerRange;
    @Shadow
    private int spawnRange;

    @Override
    public int bridge$getSpawnDelay() {
        return this.spawnDelay;
    }

    @Override
    public void bridge$setSpawnDelay(int spawnDelay) {
        this.spawnDelay = spawnDelay;
    }

    @Override
    public int bridge$getMinSpawnDelay() {
        return this.minSpawnDelay;
    }

    @Override
    public int bridge$getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    @Override
    public int bridge$getSpawnCount() {
        return this.spawnCount;
    }

    @Override
    public int bridge$getMaxNearbyEntities() {
        return this.maxNearbyEntities;
    }

    @Override
    public void bridge$setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    @Override
    public int bridge$getActivatingRangeFromPlayer() {
        return this.requiredPlayerRange;
    }

    @Override
    public int bridge$getSpawnRange() {
        return this.spawnRange;
    }

    @Redirect(method={"isNearPlayer()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;hasNearbyAlivePlayer(DDDD)Z"))
    public boolean impl$checkPlayerSpawningStateForActivation(Level world, double x, double y, double z, double distance) {
        for (Player playerentity : world.players()) {
            if (!EntitySelector.NO_SPECTATORS.test(playerentity) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(playerentity) || !((PlayerBridge)playerentity).bridge$affectsSpawning()) continue;
            double d0 = playerentity.distanceToSqr(x, y, z);
            if (!(distance < 0.0) && !(d0 < distance * distance)) continue;
            return true;
        }
        return false;
    }
}

