/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.spongepowered.api.block.entity.carrier.furnace.FurnaceBlockEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.CookingEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.level.block.entity.BaseContainerBlockEntityMixin;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin
extends BaseContainerBlockEntityMixin {
    @Shadow
    protected NonNullList<ItemStack> items;
    @Shadow
    private int cookingProgress;
    @Shadow
    private int cookingTotalTime;
    @Shadow
    @Final
    protected RecipeType<? extends AbstractCookingRecipe> recipeType;

    @Shadow
    protected abstract boolean shadow$canBurn(Recipe<?> var1);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V"))
    private void impl$throwFuelEventIfOrShrink(ItemStack itemStack, int quantity) {
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf(itemStack);
        ItemStackSnapshot shrinkedFuel = ItemStackUtil.snapshotOf(ItemStackUtil.cloneDefensive(itemStack, itemStack.getCount() - 1));
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(fuel, shrinkedFuel);
        AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
        CookingEvent.ConsumeFuel event = SpongeEventFactory.createCookingEventConsumeFuel(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.of((CookingRecipe)recipe), Collections.singletonList(transaction));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            this.cookingTotalTime = 0;
            return;
        }
        if (!transaction.isValid()) {
            return;
        }
        if (transaction.custom().isPresent()) {
            this.items.set(1, (Object)ItemStackUtil.fromSnapshotToNative(transaction.finalReplacement()));
        } else {
            itemStack.shrink(quantity);
        }
    }

    private AbstractCookingRecipe impl$getCurrentRecipe() {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, (Container)((AbstractFurnaceBlockEntity)this), this.level).orElse(null);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;canBurn(Lnet/minecraft/world/item/crafting/Recipe;)Z", ordinal=1))
    private boolean impl$checkIfCanSmelt(AbstractFurnaceBlockEntity furnace, Recipe<?> recipe) {
        if (!this.shadow$canBurn(recipe)) {
            return false;
        }
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        if (this.cookingProgress == 0) {
            CookingEvent.Start event = SpongeEventFactory.createCookingEventStart(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.of((CookingRecipe)recipe));
            SpongeCommon.post(event);
            return !event.isCancelled();
        }
        ItemStackSnapshot stack = ItemStackUtil.snapshotOf((ItemStack)this.items.get(0));
        CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (FurnaceBlockEntity)((Object)this), stack, Optional.of(fuel), Optional.of((CookingRecipe)recipe));
        SpongeCommon.post(event);
        return !event.isCancelled();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I"))
    private int impl$resetCookTimeIfCancelled(int newCookTime, int zero, int totalCookTime) {
        int clampedCookTime = Mth.clamp((int)newCookTime, (int)zero, (int)totalCookTime);
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
        ItemStackSnapshot stack = ItemStackUtil.snapshotOf((ItemStack)this.items.get(0));
        CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (FurnaceBlockEntity)((Object)this), stack, Optional.of(fuel), Optional.of((CookingRecipe)recipe));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return this.cookingProgress;
        }
        return clampedCookTime;
    }

    @Inject(method={"setItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;getTotalCookTime()I")})
    private void impl$interruptSmelt(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    @Inject(method={"tick"}, at={@At(shift=At.Shift.BEFORE, value="FIELD", opcode=181, target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;cookingProgress:I")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;burn(Lnet/minecraft/world/item/crafting/Recipe;)V"), to=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I"))})
    private void impl$onResetCookTimePassive(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    private void impl$callInteruptSmeltEvent() {
        if (this.cookingProgress > 0) {
            ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
            Cause cause = PhaseTracker.getCauseStackManager().currentCause();
            AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
            CookingEvent.Interrupt event = SpongeEventFactory.createCookingEventInterrupt(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.ofNullable((CookingRecipe)recipe));
            SpongeCommon.post(event);
        }
    }

    @Inject(method={"burn"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V")})
    private void impl$afterSmeltItem(Recipe<?> recipe, CallbackInfo ci) {
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.items.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(recipe.getResultItem());
        CookingEvent.Finish event = SpongeEventFactory.createCookingEventFinish(cause, (FurnaceBlockEntity)((Object)this), Collections.singletonList(snapshot), Optional.of(fuel), Optional.ofNullable((CookingRecipe)recipe));
        SpongeCommon.post(event);
    }
}

