/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.entitycollision.CollisionCapabilityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkMixin_EntityCollision {
    @Shadow
    public abstract Level shadow$getLevel();

    @Inject(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/List;Ljava/util/function/Predicate;)V", "getEntities(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/phys/AABB;Ljava/util/List;Ljava/util/function/Predicate;)V", "getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;Ljava/util/List;Ljava/util/function/Predicate;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    private void collisionsImpl$checkForCollisionRules(@Coerce @Nullable Object entity, AABB bb, List<Entity> entities, Predicate<? super Entity> filter, CallbackInfo ci) {
        if (this.shadow$getLevel().isClientSide() || entities == null) {
            return;
        }
        if (entity instanceof Class && (Player.class.isAssignableFrom((Class)entity) || ItemEntity.class == entity)) {
            return;
        }
        if (entity instanceof Player || entity instanceof EnderDragon) {
            return;
        }
        if (entity instanceof LivingEntity && ((CollisionCapabilityBridge)entity).collision$isRunningCollideWithNearby()) {
            return;
        }
        if (!this.entityCollision$allowEntityCollision(entities)) {
            ci.cancel();
        }
    }

    private <T extends Entity> boolean entityCollision$allowEntityCollision(List<T> entities) {
        if (((LevelBridge)this.shadow$getLevel()).bridge$isFake()) {
            return true;
        }
        PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
        if (!phaseContext.allowsEntityCollisionEvents()) {
            return true;
        }
        Object source = phaseContext.getSource();
        if (source == null) {
            return true;
        }
        CollisionCapabilityBridge collisionBridge = null;
        if (source instanceof LocatableBlock) {
            LocatableBlock locatable = (LocatableBlock)source;
            BlockType blockType = locatable.location().block().type();
            collisionBridge = (CollisionCapabilityBridge)((Object)blockType);
        } else if (source instanceof CollisionCapabilityBridge) {
            collisionBridge = (CollisionCapabilityBridge)source;
        }
        if (collisionBridge == null) {
            return true;
        }
        if (collisionBridge.collision$requiresCollisionsCacheRefresh()) {
            collisionBridge.collision$initializeCollisionState(this.shadow$getLevel());
            collisionBridge.collision$requiresCollisionsCacheRefresh(false);
        }
        return collisionBridge.collision$getMaxCollisions() < 0 || entities.size() < collisionBridge.collision$getMaxCollisions();
    }
}

