/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;

@Mixin(value={Entity.class}, priority=1500)
public abstract class EntityMixin_Optimization_Collision {
    @Inject(method={"checkInsideBlocks"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$checkForNeighboringChunkIfAvailable(CallbackInfo ci) {
        LevelChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || !activeChunk.bridge$areNeighborsLoaded() || activeChunk.bridge$isQueuedForUnload()) {
            ci.cancel();
        }
    }

    @Redirect(method={"checkInsideBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;hasChunksAt(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Z"))
    private boolean activeCollision$ignoreWorldIsAreaLoaded(Level world, BlockPos from, BlockPos to) {
        return true;
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$BailIfNeighborsAreInactive(Tag<Fluid> p_210500_1_, double p_201500_2_, CallbackInfoReturnable<Boolean> cir) {
        LevelChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || activeChunk.bridge$isQueuedForUnload() || !activeChunk.bridge$areNeighborsLoaded()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"updateFluidHeightAndDoFluidPushing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;hasChunksAt(IIIIII)Z"))
    private boolean activeCollision$IgnoreAreaIsLoaded(Level world, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        if (((LevelBridge)world).bridge$isFake()) {
            return world.hasChunksAt(xStart, yStart, zStart, xEnd, yEnd, zEnd);
        }
        return true;
    }
}

