/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.realtime.tileentity;

import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.common.bridge.RealTimeTrackingBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.mixin.core.world.level.block.entity.BlockEntityMixin;

@Mixin(value={AbstractFurnaceBlockEntity.class}, priority=1001)
public abstract class AbstractFurnaceBlockEntityMixin_RealTime
extends BlockEntityMixin {
    @Shadow
    private int litTime;
    @Shadow
    private int cookingProgress;
    @Shadow
    private int cookingTotalTime;

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;litTime:I", opcode=181), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;isLit()Z", opcode=1), to=@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;level:Lnet/minecraft/world/level/Level;", opcode=180, ordinal=0)))
    private void realTimeImpl$adjustForRealTimeBurnTime(AbstractFurnaceBlockEntity self, int modifier) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            this.litTime = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.level).realTimeBridge$getRealTimeTicks();
        this.litTime = Math.max(0, this.litTime - Math.max(1, ticks - 1));
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;cookingProgress:I", opcode=181), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;canBurn(Lnet/minecraft/world/item/crafting/Recipe;)Z", ordinal=1), to=@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;cookingTotalTime:I", opcode=180, ordinal=0)))
    private void realTimeImpl$adjustForRealTimeCookTime(AbstractFurnaceBlockEntity self, int modifier) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            this.cookingProgress = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.level).realTimeBridge$getRealTimeTicks();
        this.cookingProgress = Math.min(this.cookingTotalTime, this.cookingProgress + ticks);
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;cookingProgress:I", opcode=181), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I"), to=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z")))
    private void realTimeImpl$adjustForRealTimeCookTimeCooldown(AbstractFurnaceBlockEntity self, int modifier) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            this.cookingProgress = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.level).realTimeBridge$getRealTimeTicks();
        this.cookingProgress = Mth.clamp((int)(this.cookingProgress - 2 * ticks), (int)0, (int)this.cookingTotalTime);
    }
}

