/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.entity.PlayerTracker;

@Mixin(value={Entity.class, BlockEntity.class})
public abstract class CreatorTrackedMixin_Tracker
implements CreatorTrackedBridge {
    private @Nullable UUID tracker$creator;
    private @Nullable UUID tracker$notifier;

    @Override
    public Optional<UUID> tracker$getCreatorUUID() {
        return Optional.ofNullable(this.tracker$creator);
    }

    @Override
    public Optional<UUID> tracker$getNotifierUUID() {
        return Optional.ofNullable(this.tracker$notifier);
    }

    @Override
    public void tracker$setTrackedUUID(PlayerTracker.Type type, @Nullable UUID uuid) {
        if (PlayerTracker.Type.CREATOR == type) {
            this.tracker$creator = uuid;
            if (uuid == null) {
                ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.CREATOR);
            } else {
                ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.CREATOR, uuid);
            }
        } else if (PlayerTracker.Type.NOTIFIER == type) {
            this.tracker$notifier = uuid;
            if (uuid == null) {
                ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.NOTIFIER);
            } else {
                ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.NOTIFIER, uuid);
            }
        }
    }

    private @Nullable UUID getTrackedUniqueId(PlayerTracker.Type type) {
        if (this.tracker$creator != null && PlayerTracker.Type.CREATOR == type) {
            return this.tracker$creator;
        }
        if (this instanceof TamableAnimal) {
            TamableAnimal ownable = (TamableAnimal)this;
            LivingEntity owner = ownable.getOwner();
            if (owner instanceof Player) {
                this.tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, owner.getUUID());
                return owner.getUUID();
            }
        } else if (this.tracker$notifier != null && PlayerTracker.Type.NOTIFIER == type) {
            return this.tracker$notifier;
        }
        return null;
    }
}

