/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.chunk;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.TickList;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoTickList;
import net.minecraft.world.phys.AABB;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.TrackedLevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkMixin_Tracker
implements TrackedLevelChunkBridge {
    @Shadow
    @Final
    public static LevelChunkSection EMPTY_SECTION;
    @Shadow
    @Final
    private LevelChunkSection[] sections;
    @Shadow
    @Final
    private Level level;
    private @MonotonicNonNull PhaseContext<@NonNull ?> tracker$postProcessContext = null;

    @Shadow
    public abstract @Nullable BlockEntity shadow$getBlockEntity(BlockPos var1, LevelChunk.EntityCreationType var2);

    @Shadow
    public abstract BlockState shadow$getBlockState(BlockPos var1);

    @Inject(method={"setBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void tracker$setBlockState(BlockPos pos, BlockState newState, boolean isMoving, CallbackInfoReturnable<BlockState> cir) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            return;
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked block change on a chunk while not on the main thread!");
        }
        BlockState currentState = this.shadow$getBlockState(pos);
        if (currentState == newState) {
            cir.setReturnValue(null);
            return;
        }
        SpongeBlockChangeFlag spongeFlag = (SpongeBlockChangeFlag)BlockChangeFlags.NONE.withBlocksMoving(isMoving);
        int limit = 512;
        ChunkPipeline chunkPipeline = this.bridge$createChunkPipeline(pos, newState, currentState, spongeFlag, 512);
        cir.setReturnValue((Object)chunkPipeline.processChange(instance.getPhaseContext(), currentState, newState, pos, 512));
    }

    @Override
    public @NonNull ChunkPipeline bridge$createChunkPipeline(BlockPos pos, BlockState newState, BlockState currentState, SpongeBlockChangeFlag flag, int limit) {
        boolean isFake = ((LevelBridge)this.level).bridge$isFake();
        if (isFake) {
            throw new IllegalStateException("Cannot call ChunkBridge.bridge$buildChunkPipeline in non-Server managed worlds");
        }
        int xPos = pos.getX() & 0xF;
        int yPos = pos.getY();
        int zPos = pos.getZ() & 0xF;
        LevelChunkSection chunksection = this.sections[yPos >> 4];
        if (chunksection == EMPTY_SECTION) {
            if (newState.isAir()) {
                return ChunkPipeline.nullReturn((LevelChunk)this, (ServerLevel)this.level);
            }
            this.sections[yPos >> 4] = chunksection = new LevelChunkSection(yPos >> 4 << 4);
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        @Nullable BlockEntity existing = this.shadow$getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        WeakReference<ServerLevel> ref = new WeakReference<ServerLevel>((ServerLevel)this.level);
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(currentState, pos, flag, limit, existing, () -> Objects.requireNonNull((ServerLevel)ref.get(), "ServerWorld dereferenced"), Optional::empty, Optional::empty);
        ChangeBlock transaction = context.createTransaction(snapshot, newState, flag);
        snapshot.blockChange = context.associateBlockChangeWithSnapshot(newState, currentState);
        if (((BlockStateBridge)((Object)snapshot.state())).bridge$hasTileEntity() && (snapshot.blockChange == BlockChange.BREAK || snapshot.blockChange == BlockChange.MODIFY)) {
            transaction.queuedRemoval = existing;
        }
        ChunkPipeline.Builder builder = ChunkPipeline.builder().kickOff(transaction).chunk((LevelChunk)this).chunkSection(chunksection).world((ServerLevel)this.level);
        transaction.populateChunkEffects(builder);
        return builder.build();
    }

    @Inject(method={"addEntity"}, at={@At(value="RETURN")})
    private void tracker$SetActiveChunkOnEntityAdd(Entity entityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)entityIn).bridge$setActiveChunk(this);
    }

    @Inject(method={"removeEntity(Lnet/minecraft/world/entity/Entity;I)V"}, at={@At(value="RETURN")})
    private void tracker$ResetEntityActiveChunk(Entity entityIn, int index, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)entityIn).bridge$setActiveChunk(null);
    }

    @Inject(method={"postProcessGeneration"}, at={@At(value="HEAD")})
    private void tracker$startChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext != null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.SERVER, "Expected to not have a chunk post process", "Chunk Post Process has not completed!", GenerationPhase.State.CHUNK_LOADING, this.tracker$postProcessContext, (Throwable)new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
            this.tracker$postProcessContext.close();
        }
        this.tracker$postProcessContext = ((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.SERVER).chunk((LevelChunk)this).world((ServerLevel)this.level)).buildAndSwitch();
    }

    @Inject(method={"postProcessGeneration"}, at={@At(value="RETURN")})
    private void tracker$endChunkPostProcess(CallbackInfo ci) {
        if (this.tracker$postProcessContext == null) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.getInstance(), "Expected to complete Chunk Post Process", "Chunk Post Process has a null PhaseContext", new NullPointerException("spongecommon.ChunkMixin_Tracker:tracker$postProcessContext is Null"));
        }
        this.tracker$postProcessContext.close();
        this.tracker$postProcessContext = null;
    }

    @Redirect(method={"removeBlockEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntity;setRemoved()V"))
    private void tracker$resetTileEntityActiveChunk(BlockEntity tileEntityIn) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(null);
        tileEntityIn.setRemoved();
    }

    @Inject(method={"setBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntity;clearRemoved()V")})
    private void tracker$SetActiveChunkOnTileEntityAdd(BlockPos pos, BlockEntity tileEntityIn, CallbackInfo ci) {
        ((ActiveChunkReferantBridge)tileEntityIn).bridge$setActiveChunk(this);
        ((CreatorTrackedBridge)tileEntityIn).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, ((LevelChunkBridge)((Object)this)).bridge$getBlockCreatorUUID(pos).orElse(null));
        ((CreatorTrackedBridge)tileEntityIn).tracker$setTrackedUUID(PlayerTracker.Type.NOTIFIER, null);
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/List;Ljava/util/function/Predicate;)V", "getEntities(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/phys/AABB;Ljava/util/List;Ljava/util/function/Predicate;)V", "getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;Ljava/util/List;Ljava/util/function/Predicate;)V"}, at={@At(value="RETURN")})
    private void tracker$ThrowCollisionEvent(@Coerce Object entityIn, AABB aabb, List<Entity> listToFill, Predicate<?> filter, CallbackInfo ci) {
        Entity entity;
        if (((LevelBridge)this.level).bridge$isFake() || !PhaseTracker.getInstance().getPhaseContext().allowsEntityCollisionEvents()) {
            return;
        }
        if (listToFill.isEmpty()) {
            return;
        }
        if (!ShouldFire.COLLIDE_ENTITY_EVENT) {
            return;
        }
        Entity entity2 = entity = entityIn instanceof Entity ? (Entity)entityIn : null;
        if (SpongeCommonEventFactory.callCollideEntityEvent(entity, listToFill).isCancelled()) {
            listToFill.clear();
        }
    }

    @Redirect(method={"unpackTicks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ProtoTickList;copyOut(Lnet/minecraft/world/level/TickList;Ljava/util/function/Function;)V"))
    private void tracker$wrapRescheduledTicks(ProtoTickList chunkPrimerTickList, TickList<?> tickList, Function<BlockPos, ?> func) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return;
        }
        try (ChunkLoadContext context = GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.SERVER);){
            context.chunk((LevelChunk)this);
            context.buildAndSwitch();
            chunkPrimerTickList.copyOut(tickList, func);
        }
    }
}

