/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.chunk.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerMixin_Tracker {
    @Inject(method={"write"}, at={@At(value="RETURN")})
    private static void impl$writeSpongeLevelData(ServerLevel param0, ChunkAccess param1, CallbackInfoReturnable<CompoundTag> cir) {
        if (!(param1 instanceof LevelChunk)) {
            return;
        }
        LevelChunkBridge chunk = (LevelChunkBridge)param1;
        if (!chunk.bridge$getTrackedShortPlayerPositions().isEmpty() || !chunk.bridge$getTrackedIntPlayerPositions().isEmpty()) {
            CompoundTag level = (CompoundTag)((CompoundTag)cir.getReturnValue()).get("Level");
            CompoundTag trackedNbt = new CompoundTag();
            ListTag positions = new ListTag();
            trackedNbt.put("BlockPosTable", (Tag)positions);
            level.put("SpongeData", (Tag)trackedNbt);
            ChunkSerializerMixin_Tracker.impl$writeMap(positions, chunk.bridge$getTrackedShortPlayerPositions(), (nbt, pos) -> nbt.putShort("pos", pos.shortValue()));
            ChunkSerializerMixin_Tracker.impl$writeMap(positions, chunk.bridge$getTrackedIntPlayerPositions(), (nbt, pos) -> nbt.putInt("ipos", pos.intValue()));
        }
    }

    private static <T> void impl$writeMap(ListTag positions, Map<T, PlayerTracker> map, BiConsumer<CompoundTag, T> consumer) {
        for (Map.Entry<T, PlayerTracker> mapEntry : map.entrySet()) {
            T pos = mapEntry.getKey();
            int ownerUniqueIdIndex = mapEntry.getValue().creatorindex;
            int notifierUniqueIdIndex = mapEntry.getValue().notifierIndex;
            CompoundTag valueNbt = new CompoundTag();
            valueNbt.putInt("owner", ownerUniqueIdIndex);
            valueNbt.putInt("notifier", notifierUniqueIdIndex);
            consumer.accept(valueNbt, (CompoundTag)pos);
            positions.add((Object)valueNbt);
        }
    }

    @Redirect(method={"read"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkAccess;setLightCorrect(Z)V"))
    private static void impl$readSpongeLevelData(ChunkAccess chunkAccess, boolean var1, ServerLevel param0, StructureManager param1, PoiManager param2, ChunkPos param3, CompoundTag param4) {
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        CompoundTag level = (CompoundTag)param4.get("Level");
        CompoundTag spongeData = level.getCompound("SpongeData");
        if (spongeData.isEmpty()) {
            return;
        }
        HashMap<Integer, PlayerTracker> trackedIntPlayerPositions = new HashMap<Integer, PlayerTracker>();
        HashMap<Short, PlayerTracker> trackedShortPlayerPositions = new HashMap<Short, PlayerTracker>();
        ListTag list = spongeData.getList("BlockPosTable", 10);
        LevelChunkBridge chunk = (LevelChunkBridge)chunkAccess;
        for (Tag tag : list) {
            PlayerTracker tracker = new PlayerTracker();
            CompoundTag data = (CompoundTag)tag;
            boolean isShortPos = data.contains("pos");
            if (data.contains("owner")) {
                tracker.creatorindex = data.getInt("owner");
            }
            if (data.contains("notifier")) {
                tracker.notifierIndex = data.getInt("notifier");
            }
            if (tracker.notifierIndex == -1 && tracker.creatorindex == -1) continue;
            if (isShortPos) {
                trackedShortPlayerPositions.put(data.getShort("pos"), tracker);
                continue;
            }
            trackedIntPlayerPositions.put(data.getInt("ipos"), tracker);
        }
        chunk.bridge$setTrackedIntPlayerPositions(trackedIntPlayerPositions);
        chunk.bridge$setTrackedShortPlayerPositions(trackedShortPlayerPositions);
    }
}

