/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.common.network.channel.ChannelBuffers;

public final class RegisterChannelUtil {
    private static final char SEPARATOR = '\u0000';
    private static final Splitter SPLITTER = Splitter.on((char)'\u0000');
    private static final Joiner JOINER = Joiner.on((char)'\u0000');

    public static List<ResourceKey> decodePayload(ChannelBuf payload) {
        byte[] content = payload.readBytes(payload.available());
        return SPLITTER.splitToList((CharSequence)new String(content, StandardCharsets.UTF_8)).stream().map(ResourceKey::resolve).collect(Collectors.toList());
    }

    public static ChannelBuf encodePayload(Iterable<ResourceKey> keys) {
        String content = JOINER.join(keys);
        return ChannelBuffers.wrap(Unpooled.wrappedBuffer((byte[])content.getBytes(StandardCharsets.UTF_8)));
    }

    private RegisterChannelUtil() {
    }
}

