/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.bridge.world.level.ExplosionBridge;
import org.spongepowered.math.vector.Vector3d;

public class SpongeExplosionBuilder
implements Explosion.Builder {
    private ServerLocation location;
    private @Nullable Explosive sourceExplosive;
    private float radius;
    private boolean canCauseFire;
    private boolean shouldBreakBlocks = true;
    private boolean shouldSmoke;
    private boolean shouldDamageEntities = true;
    private int resolution = 16;
    private float randomness = 1.0f;
    private double knockback = 1.0;

    public SpongeExplosionBuilder() {
        this.reset();
    }

    @Override
    public Explosion.Builder sourceExplosive(@Nullable Explosive source) {
        this.sourceExplosive = source;
        return this;
    }

    @Override
    public Explosion.Builder radius(float radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public Explosion.Builder location(ServerLocation location) {
        this.location = Objects.requireNonNull(location, "location");
        return this;
    }

    @Override
    public Explosion.Builder canCauseFire(boolean fire) {
        this.canCauseFire = fire;
        return this;
    }

    @Override
    public Explosion.Builder shouldDamageEntities(boolean damage) {
        this.shouldDamageEntities = damage;
        return this;
    }

    @Override
    public Explosion.Builder shouldPlaySmoke(boolean smoke) {
        this.shouldSmoke = smoke;
        return this;
    }

    @Override
    public Explosion.Builder shouldBreakBlocks(boolean destroy) {
        this.shouldBreakBlocks = destroy;
        return this;
    }

    @Override
    public Explosion.Builder resolution(int resolution) {
        this.resolution = Math.max(resolution, 2);
        return this;
    }

    @Override
    public Explosion.Builder randomness(float randomness) {
        this.randomness = randomness;
        return this;
    }

    @Override
    public Explosion.Builder knockback(double knockback) {
        this.knockback = knockback;
        return this;
    }

    @Override
    public Explosion.Builder from(org.spongepowered.api.world.explosion.Explosion value) {
        this.location = value.serverLocation();
        this.sourceExplosive = value.sourceExplosive().orElse(null);
        this.radius = value.radius();
        this.canCauseFire = value.canCauseFire();
        this.shouldBreakBlocks = value.shouldBreakBlocks();
        this.shouldSmoke = value.shouldPlaySmoke();
        this.shouldDamageEntities = value.shouldDamageEntities();
        this.resolution = value.resolution();
        this.randomness = value.randomness();
        this.knockback = value.knockback();
        return this;
    }

    @Override
    public SpongeExplosionBuilder reset() {
        this.location = null;
        this.sourceExplosive = null;
        this.radius = 0.0f;
        this.canCauseFire = false;
        this.shouldBreakBlocks = true;
        this.shouldSmoke = false;
        this.shouldDamageEntities = true;
        this.resolution = 16;
        this.randomness = 1.0f;
        this.knockback = 1.0;
        return this;
    }

    @Override
    public org.spongepowered.api.world.explosion.Explosion build() throws IllegalStateException {
        Preconditions.checkState((this.location != null ? 1 : 0) != 0, (Object)"Location is null!");
        Object world = this.location.world();
        Vector3d origin = this.location.position();
        Explosion explosion = new Explosion((Level)world, (Entity)this.sourceExplosive, null, null, origin.x(), origin.y(), origin.z(), this.radius, this.canCauseFire, this.shouldBreakBlocks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        ((ExplosionBridge)explosion).bridge$setShouldBreakBlocks(this.shouldBreakBlocks);
        ((ExplosionBridge)explosion).bridge$setShouldDamageEntities(this.shouldDamageEntities);
        ((ExplosionBridge)explosion).bridge$setShouldPlaySmoke(this.shouldSmoke);
        ((ExplosionBridge)explosion).bridge$setResolution(this.resolution);
        ((ExplosionBridge)explosion).bridge$setRandomness(this.randomness);
        ((ExplosionBridge)explosion).bridge$setKnockback(this.knockback);
        return (org.spongepowered.api.world.explosion.Explosion)explosion;
    }
}

