/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import java.util.Objects;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlideSettings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;
import org.spongepowered.api.world.generation.config.noise.SamplingConfig;
import org.spongepowered.api.world.generation.config.noise.SlideConfig;

public final class SpongeNoiseConfig {
    private SpongeNoiseConfig() {
    }

    public static final class FactoryImpl
    implements NoiseConfig.Factory {
        private static final NoiseConfig OVERWORLD = (NoiseConfig)new NoiseSettings(256, new NoiseSamplingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new NoiseSlideSettings(-10, 3, 0), new NoiseSlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, false);
        private static final NoiseConfig NETHER = (NoiseConfig)new NoiseSettings(128, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlideSettings(120, 3, 0), new NoiseSlideSettings(320, 4, -1), 1, 2, 0.0, 0.019921875, false, false, false, false);
        private static final NoiseConfig END = (NoiseConfig)new NoiseSettings(128, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlideSettings(-3000, 64, -46), new NoiseSlideSettings(-30, 7, 1), 2, 1, 0.0, 0.0, true, false, false, false);

        @Override
        public NoiseConfig overworld() {
            return OVERWORLD;
        }

        @Override
        public NoiseConfig nether() {
            return NETHER;
        }

        @Override
        public NoiseConfig end() {
            return END;
        }
    }

    public static final class BuilderImpl
    implements NoiseConfig.Builder {
        public SamplingConfig sampling;
        public SlideConfig top;
        public SlideConfig bottom;
        public int height;
        public int horizontalSize;
        public int verticalSize;
        public double densityFactor;
        public double densityOffset;
        public boolean simplexForSurface;
        public boolean randomizeDensityOffset;
        public boolean amplified;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public NoiseConfig.Builder height(int height) {
            this.height = height;
            return this;
        }

        @Override
        public NoiseConfig.Builder sampling(SamplingConfig sampling) {
            this.sampling = Objects.requireNonNull(sampling, "sampling");
            return this;
        }

        @Override
        public NoiseConfig.Builder top(SlideConfig top) {
            this.top = Objects.requireNonNull(top, "top");
            return this;
        }

        @Override
        public NoiseConfig.Builder bottom(SlideConfig bottom) {
            this.bottom = Objects.requireNonNull(bottom, "bottom");
            return this;
        }

        @Override
        public NoiseConfig.Builder horizontalSize(int horizontal) {
            this.horizontalSize = horizontal;
            return this;
        }

        @Override
        public NoiseConfig.Builder verticalSize(int vertical) {
            this.verticalSize = vertical;
            return this;
        }

        @Override
        public NoiseConfig.Builder densityFactor(double densityFactor) {
            this.densityFactor = densityFactor;
            return this;
        }

        @Override
        public NoiseConfig.Builder densityOffset(double densityOffset) {
            this.densityOffset = densityOffset;
            return this;
        }

        @Override
        public NoiseConfig.Builder simplexForSurface(boolean simplex) {
            this.simplexForSurface = simplex;
            return this;
        }

        @Override
        public NoiseConfig.Builder randomizeDensityOffset(boolean randomDensityOffset) {
            this.randomizeDensityOffset = randomDensityOffset;
            return this;
        }

        @Override
        public NoiseConfig.Builder amplified(boolean amplified) {
            this.amplified = amplified;
            return this;
        }

        @Override
        public NoiseConfig.Builder reset() {
            this.sampling = SamplingConfig.of(0.9999999814507745, 80.0, 0.9999999814507745, 160.0);
            this.top = SlideConfig.of(-10, 3, 0);
            this.bottom = SlideConfig.of(-30, 0, 0);
            this.height = 256;
            this.horizontalSize = 1;
            this.verticalSize = 2;
            this.densityFactor = 1.0;
            this.densityOffset = -0.46875;
            this.simplexForSurface = true;
            this.randomizeDensityOffset = true;
            this.amplified = false;
            return this;
        }

        @Override
        public NoiseConfig.Builder from(NoiseConfig value) {
            Objects.requireNonNull(value, "value");
            this.sampling = value.samplingConfig();
            this.top = value.topConfig();
            this.bottom = value.bottomConfig();
            this.height = value.height();
            this.horizontalSize = value.horizontalSize();
            this.verticalSize = value.verticalSize();
            this.densityFactor = value.densityFactor();
            this.densityOffset = value.densityOffset();
            this.simplexForSurface = value.simplexForSurface();
            this.randomizeDensityOffset = value.randomizeDensityOffset();
            this.amplified = value.amplified();
            return this;
        }

        public @NonNull NoiseConfig build() {
            Objects.requireNonNull(this.sampling, "sampling");
            Objects.requireNonNull(this.top, "top");
            Objects.requireNonNull(this.bottom, "bottom");
            return (NoiseConfig)new NoiseSettings(this.height, (NoiseSamplingSettings)this.sampling, (NoiseSlideSettings)this.top, (NoiseSlideSettings)this.bottom, this.horizontalSize, this.verticalSize, this.densityFactor, this.densityOffset, this.simplexForSurface, this.randomizeDensityOffset, false, this.amplified);
        }
    }
}

