/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.WorldTypes;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.generation.config.NoiseGeneratorConfig;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.AbstractResourceKeyed;
import org.spongepowered.common.accessor.world.gen.DimensionGeneratorSettingsAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.data.fixer.SpongeDataCodec;
import org.spongepowered.common.serialization.EnumCodec;
import org.spongepowered.common.serialization.MathCodecs;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeWorldTemplate
extends AbstractResourceKeyed
implements WorldTemplate {
    public final @Nullable Component displayName;
    public final RegistryReference<WorldType> worldType;
    public final org.spongepowered.api.world.generation.ChunkGenerator generator;
    public final WorldGenerationConfig generationConfig;
    public final @Nullable SerializationBehavior serializationBehavior;
    public final @Nullable RegistryReference<GameMode> gameMode;
    public final @Nullable RegistryReference<Difficulty> difficulty;
    public final @Nullable Integer viewDistance;
    public final @Nullable Vector3i spawnPosition;
    public final @Nullable Boolean hardcore;
    public final @Nullable Boolean pvp;
    public final @Nullable Boolean commands;
    public final boolean loadOnStartup;
    public final boolean performsSpawnLogic;
    private static final Codec<SpongeDataSection> SPONGE_CODEC = RecordCodecBuilder.create(r -> r.group((App)SpongeAdventure.STRING_CODEC.optionalFieldOf("display_name").forGetter(v -> Optional.ofNullable(v.displayName)), (App)ResourceLocation.CODEC.optionalFieldOf("game_mode").forGetter(v -> Optional.ofNullable(v.gameMode)), (App)ResourceLocation.CODEC.optionalFieldOf("difficulty").forGetter(v -> Optional.ofNullable(v.difficulty)), (App)EnumCodec.create(SerializationBehavior.class).optionalFieldOf("serialization_behavior").forGetter(v -> Optional.ofNullable(v.serializationBehavior)), (App)Codec.INT.optionalFieldOf("view_distance").forGetter(v -> Optional.ofNullable(v.viewDistance)), (App)MathCodecs.VECTOR_3i.optionalFieldOf("spawn_position").forGetter(v -> Optional.ofNullable(v.spawnPosition)), (App)Codec.BOOL.optionalFieldOf("load_on_startup").forGetter(v -> Optional.ofNullable(v.loadOnStartup)), (App)Codec.BOOL.optionalFieldOf("performs_spawn_logic").forGetter(v -> Optional.ofNullable(v.performsSpawnLogic)), (App)Codec.BOOL.optionalFieldOf("hardcore").forGetter(v -> Optional.ofNullable(v.hardcore)), (App)Codec.BOOL.optionalFieldOf("commands").forGetter(v -> Optional.ofNullable(v.commands)), (App)Codec.BOOL.optionalFieldOf("pvp").forGetter(v -> Optional.ofNullable(v.pvp))).apply((Applicative)r, (f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11) -> new SpongeDataSection(f1.orElse(null), f2.orElse(null), f3.orElse(null), f4.orElse(null), f5.orElse(null), f6.orElse(null), f7.orElse(null), f8.orElse(null), f9.orElse(null), f10.orElse(null), f11.orElse(null))));
    public static final Codec<LevelStem> DIRECT_CODEC = new MapCodec.MapCodecCodec(new SpongeDataCodec<LevelStem, SpongeDataSection>(LevelStem.CODEC, SPONGE_CODEC, (type, data) -> ((LevelStemBridge)type).bridge$decorateData((SpongeDataSection)data), type -> ((LevelStemBridge)type).bridge$createData()));

    protected SpongeWorldTemplate(BuilderImpl builder) {
        super(builder.key);
        this.displayName = builder.displayName;
        this.worldType = builder.worldType;
        this.generator = builder.generator;
        this.generationConfig = builder.generationConfig;
        this.gameMode = builder.gameMode;
        this.difficulty = builder.difficulty;
        this.serializationBehavior = builder.serializationBehavior;
        this.viewDistance = builder.viewDistance;
        this.spawnPosition = builder.spawnPosition;
        this.loadOnStartup = builder.loadOnStartup;
        this.performsSpawnLogic = builder.performsSpawnLogic;
        this.hardcore = builder.hardcore;
        this.commands = builder.commands;
        this.pvp = builder.pvp;
    }

    public SpongeWorldTemplate(ServerLevel world) {
        super((ResourceKey)world.dimension().location());
        ServerWorldProperties levelData = (ServerWorldProperties)world.getLevelData();
        PrimaryLevelDataBridge levelBridge = (PrimaryLevelDataBridge)world.getLevelData();
        this.displayName = levelBridge.bridge$displayName().orElse(null);
        this.worldType = ((WorldType)world.dimensionType()).asDefaultedReference(RegistryTypes.WORLD_TYPE);
        this.generator = (org.spongepowered.api.world.generation.ChunkGenerator)world.getChunkSource().getGenerator();
        this.generationConfig = ((WorldGenerationConfig.Mutable.Builder)WorldGenerationConfig.Mutable.builder().from(levelData.worldGenerationConfig())).build();
        this.gameMode = levelBridge.bridge$customGameType() ? levelData.gameMode().asDefaultedReference(RegistryTypes.GAME_MODE) : null;
        this.difficulty = levelBridge.bridge$customDifficulty() ? levelData.difficulty().asDefaultedReference(RegistryTypes.DIFFICULTY) : null;
        this.serializationBehavior = levelBridge.bridge$serializationBehavior().orElse(null);
        this.viewDistance = levelBridge.bridge$viewDistance().orElse(null);
        this.spawnPosition = levelBridge.bridge$customSpawnPosition() ? levelData.spawnPosition() : null;
        this.loadOnStartup = levelData.loadOnStartup();
        this.performsSpawnLogic = levelData.performsSpawnLogic();
        this.hardcore = levelData.hardcore();
        this.commands = levelData.commands();
        this.pvp = levelData.pvp();
    }

    public SpongeWorldTemplate(LevelStem template) {
        super(((ResourceKeyBridge)template).bridge$getKey());
        LevelStemBridge templateBridge = (LevelStemBridge)template;
        this.displayName = templateBridge.bridge$displayName().orElse(null);
        this.worldType = ((WorldType)template.type()).asDefaultedReference(RegistryTypes.WORLD_TYPE);
        this.generator = (org.spongepowered.api.world.generation.ChunkGenerator)template.generator();
        this.generationConfig = ((WorldGenerationConfig.Mutable.Builder)WorldGenerationConfig.Mutable.builder().from((WorldGenerationConfig.Mutable)BootstrapProperties.worldGenSettings)).build();
        this.gameMode = templateBridge.bridge$gameMode().isPresent() ? RegistryTypes.GAME_MODE.referenced((ResourceKey)templateBridge.bridge$gameMode().get()) : null;
        this.difficulty = templateBridge.bridge$difficulty().isPresent() ? RegistryTypes.DIFFICULTY.referenced((ResourceKey)templateBridge.bridge$difficulty().get()) : null;
        this.serializationBehavior = templateBridge.bridge$serializationBehavior().orElse(null);
        this.viewDistance = templateBridge.bridge$viewDistance().orElse(null);
        this.spawnPosition = templateBridge.bridge$spawnPosition().orElse(null);
        this.loadOnStartup = templateBridge.bridge$loadOnStartup();
        this.performsSpawnLogic = templateBridge.bridge$performsSpawnLogic();
        this.hardcore = templateBridge.bridge$hardcore().orElse(null);
        this.commands = templateBridge.bridge$commands().orElse(null);
        this.pvp = templateBridge.bridge$pvp().orElse(null);
    }

    @Override
    public DataPackType<WorldTemplate> type() {
        return DataPackTypes.WORLD;
    }

    @Override
    public Optional<Component> displayName() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    public RegistryReference<WorldType> worldType() {
        return this.worldType;
    }

    @Override
    public org.spongepowered.api.world.generation.ChunkGenerator generator() {
        return this.generator;
    }

    @Override
    public WorldGenerationConfig generationConfig() {
        return this.generationConfig;
    }

    @Override
    public Optional<RegistryReference<GameMode>> gameMode() {
        return Optional.ofNullable(this.gameMode);
    }

    @Override
    public Optional<RegistryReference<Difficulty>> difficulty() {
        return Optional.ofNullable(this.difficulty);
    }

    @Override
    public Optional<SerializationBehavior> serializationBehavior() {
        return Optional.ofNullable(this.serializationBehavior);
    }

    @Override
    public boolean loadOnStartup() {
        return this.loadOnStartup;
    }

    @Override
    public boolean performsSpawnLogic() {
        return this.performsSpawnLogic;
    }

    @Override
    public Optional<Boolean> hardcore() {
        return Optional.ofNullable(this.hardcore);
    }

    @Override
    public Optional<Boolean> commands() {
        return Optional.ofNullable(this.commands);
    }

    @Override
    public Optional<Boolean> pvp() {
        return Optional.ofNullable(this.pvp);
    }

    @Override
    public Optional<Integer> viewDistance() {
        return Optional.ofNullable(this.viewDistance);
    }

    @Override
    public Optional<Vector3i> spawnPosition() {
        return Optional.ofNullable(this.spawnPosition);
    }

    @Override
    public int contentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        throw new MissingImplementationException("SpongeWorldTemplate", "toContainer");
    }

    public LevelStem asDimension() {
        LevelStem scratch = new LevelStem(() -> (DimensionType)BootstrapProperties.registries.dimensionTypes().get((ResourceLocation)this.worldType.location()), (ChunkGenerator)this.generator);
        ((LevelStemBridge)scratch).bridge$setFromSettings(false);
        ((LevelStemBridge)scratch).bridge$populateFromTemplate(this);
        return scratch;
    }

    public static final class FactoryImpl
    implements WorldTemplate.Factory {
        @Override
        public WorldTemplate overworld() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(ResourceKey.minecraft("overworld"))).worldType(WorldTypes.OVERWORLD).generator(org.spongepowered.api.world.generation.ChunkGenerator.overworld()).performsSpawnLogic(true).build();
        }

        @Override
        public WorldTemplate overworldCaves() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(ResourceKey.minecraft("overworld_caves"))).worldType(WorldTypes.OVERWORLD_CAVES).generator(org.spongepowered.api.world.generation.ChunkGenerator.noise(BiomeProvider.overworld(), NoiseGeneratorConfig.caves())).performsSpawnLogic(true).build();
        }

        @Override
        public WorldTemplate theNether() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(ResourceKey.minecraft("the_nether"))).worldType(WorldTypes.THE_NETHER).generator(org.spongepowered.api.world.generation.ChunkGenerator.theNether()).build();
        }

        @Override
        public WorldTemplate theEnd() {
            return (WorldTemplate)((WorldTemplate.Builder)new BuilderImpl().reset().key(ResourceKey.minecraft("the_end"))).worldType(WorldTypes.THE_END).generator(org.spongepowered.api.world.generation.ChunkGenerator.theEnd()).build();
        }
    }

    public static final class BuilderImpl
    extends AbstractResourceKeyedBuilder<WorldTemplate, WorldTemplate.Builder>
    implements WorldTemplate.Builder {
        @Nullable Component displayName;
        @Nullable RegistryReference<WorldType> worldType;
        @Nullable org.spongepowered.api.world.generation.ChunkGenerator generator;
        @Nullable WorldGenerationConfig generationConfig;
        @Nullable RegistryReference<GameMode> gameMode;
        @Nullable RegistryReference<Difficulty> difficulty;
        @Nullable SerializationBehavior serializationBehavior;
        @Nullable Integer viewDistance;
        @Nullable Vector3i spawnPosition;
        @Nullable Boolean hardcore;
        @Nullable Boolean pvp;
        @Nullable Boolean commands;
        boolean loadOnStartup;
        boolean performsSpawnLogic;

        @Override
        public WorldTemplate.Builder displayName(@Nullable Component displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public WorldTemplate.Builder worldType(RegistryReference<WorldType> worldType) {
            this.worldType = Objects.requireNonNull(worldType, "worldType");
            return this;
        }

        @Override
        public WorldTemplate.Builder generator(org.spongepowered.api.world.generation.ChunkGenerator generator) {
            this.generator = Objects.requireNonNull(generator, "generator");
            return this;
        }

        @Override
        public WorldTemplate.Builder generationConfig(WorldGenerationConfig generationConfig) {
            this.generationConfig = Objects.requireNonNull(generationConfig, "generationConfig");
            return this;
        }

        @Override
        public WorldTemplate.Builder gameMode(RegistryReference<GameMode> gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        @Override
        public WorldTemplate.Builder difficulty(RegistryReference<Difficulty> difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        @Override
        public WorldTemplate.Builder serializationBehavior(@Nullable SerializationBehavior serializationBehavior) {
            this.serializationBehavior = serializationBehavior;
            return this;
        }

        @Override
        public WorldTemplate.Builder loadOnStartup(boolean loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
            return this;
        }

        @Override
        public WorldTemplate.Builder performsSpawnLogic(boolean performsSpawnLogic) {
            this.performsSpawnLogic = performsSpawnLogic;
            return this;
        }

        @Override
        public WorldTemplate.Builder hardcore(@Nullable Boolean hardcore) {
            this.hardcore = hardcore;
            return this;
        }

        @Override
        public WorldTemplate.Builder commands(@Nullable Boolean commands) {
            this.commands = commands;
            return this;
        }

        @Override
        public WorldTemplate.Builder pvp(@Nullable Boolean pvp) {
            this.pvp = pvp;
            return this;
        }

        @Override
        public WorldTemplate.Builder viewDistance(@Nullable Integer distance) {
            this.viewDistance = distance;
            return this;
        }

        @Override
        public WorldTemplate.Builder spawnPosition(@Nullable Vector3i position) {
            this.spawnPosition = position;
            return this;
        }

        @Override
        public WorldTemplate.Builder reset() {
            super.reset();
            this.displayName = null;
            this.worldType = WorldTypes.OVERWORLD;
            this.generator = org.spongepowered.api.world.generation.ChunkGenerator.overworld();
            WorldGenSettings generationSettings = BootstrapProperties.worldGenSettings;
            this.generationConfig = (WorldGenerationConfig)DimensionGeneratorSettingsAccessor.invoker$new(generationSettings.seed(), generationSettings.generateFeatures(), generationSettings.generateBonusChest(), (MappedRegistry<LevelStem>)new MappedRegistry(Registry.LEVEL_STEM_REGISTRY, Lifecycle.stable()), ((DimensionGeneratorSettingsAccessor)generationSettings).accessor$legacyCustomOptions());
            this.gameMode = null;
            this.difficulty = null;
            this.serializationBehavior = null;
            this.viewDistance = null;
            this.spawnPosition = null;
            this.loadOnStartup = true;
            this.performsSpawnLogic = false;
            this.hardcore = null;
            this.commands = null;
            this.pvp = null;
            return this;
        }

        @Override
        public WorldTemplate.Builder from(WorldTemplate template) {
            this.key = Objects.requireNonNull(template, "template").key();
            this.displayName = template.displayName().orElse(null);
            this.worldType = template.worldType();
            this.generator = template.generator();
            WorldGenSettings generationSettings = (WorldGenSettings)template.generationConfig();
            this.generationConfig = (WorldGenerationConfig)DimensionGeneratorSettingsAccessor.invoker$new(generationSettings.seed(), generationSettings.generateFeatures(), generationSettings.generateBonusChest(), (MappedRegistry<LevelStem>)new MappedRegistry(Registry.LEVEL_STEM_REGISTRY, Lifecycle.stable()), ((DimensionGeneratorSettingsAccessor)generationSettings).accessor$legacyCustomOptions());
            this.gameMode = template.gameMode().orElse(null);
            this.difficulty = template.difficulty().orElse(null);
            this.serializationBehavior = template.serializationBehavior().orElse(null);
            this.viewDistance = template.viewDistance().orElse(null);
            this.spawnPosition = template.spawnPosition().orElse(null);
            this.loadOnStartup = template.loadOnStartup();
            this.performsSpawnLogic = template.performsSpawnLogic();
            this.hardcore = template.hardcore().orElse(null);
            this.commands = template.commands().orElse(null);
            this.pvp = template.pvp().orElse(null);
            return this;
        }

        @Override
        protected WorldTemplate build0() {
            return new SpongeWorldTemplate(this);
        }
    }

    public static final class SpongeDataSection {
        public final @Nullable Component displayName;
        public final @Nullable ResourceLocation gameMode;
        public final @Nullable ResourceLocation difficulty;
        public final @Nullable SerializationBehavior serializationBehavior;
        public final @Nullable Integer viewDistance;
        public final @Nullable Vector3i spawnPosition;
        public final @Nullable Boolean loadOnStartup;
        public final @Nullable Boolean performsSpawnLogic;
        public final @Nullable Boolean hardcore;
        public final @Nullable Boolean commands;
        public final @Nullable Boolean pvp;

        public SpongeDataSection(@Nullable Component displayName, @Nullable ResourceLocation gameMode, @Nullable ResourceLocation difficulty, @Nullable SerializationBehavior serializationBehavior, @Nullable Integer viewDistance, @Nullable Vector3i spawnPosition, @Nullable Boolean loadOnStartup, @Nullable Boolean performsSpawnLogic, @Nullable Boolean hardcore, @Nullable Boolean commands, @Nullable Boolean pvp) {
            this.displayName = displayName;
            this.gameMode = gameMode;
            this.difficulty = difficulty;
            this.serializationBehavior = serializationBehavior;
            this.viewDistance = viewDistance;
            this.spawnPosition = spawnPosition;
            this.loadOnStartup = loadOnStartup;
            this.performsSpawnLogic = performsSpawnLogic;
            this.hardcore = hardcore;
            this.commands = commands;
            this.pvp = pvp;
        }
    }
}

