/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.archetype;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.block.entity.BlockEntityArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeApplicators;
import org.spongepowered.api.world.volume.stream.VolumeCollectors;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.AbstractVolumeBuffer;
import org.spongepowered.common.world.volume.buffer.archetype.ReferentArchetypeVolume;
import org.spongepowered.common.world.volume.buffer.archetype.blockentity.MutableMapBlockEntityArchetypeBuffer;
import org.spongepowered.common.world.volume.buffer.archetype.entity.ObjectArrayMutableEntityArchetypeBuffer;
import org.spongepowered.common.world.volume.buffer.biome.ByteArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class SpongeArchetypeVolume
extends AbstractVolumeBuffer
implements ArchetypeVolume {
    private final ByteArrayMutableBiomeBuffer biomes;
    private final ArrayMutableBlockBuffer blocks;
    private final BlockEntityArchetypeVolume.Mutable blockEntities;
    private final ObjectArrayMutableEntityArchetypeBuffer entities;

    public SpongeArchetypeVolume(Vector3i start, Vector3i size, RegistryHolder registries) {
        super(start, size);
        ArrayMutableBlockBuffer blocks;
        this.blocks = blocks = new ArrayMutableBlockBuffer(start, size);
        this.blockEntities = new MutableMapBlockEntityArchetypeBuffer(blocks);
        this.biomes = new ByteArrayMutableBiomeBuffer(PaletteTypes.BIOME_PALETTE.get().create(registries, RegistryTypes.BIOME), start, size);
        this.entities = new ObjectArrayMutableEntityArchetypeBuffer(start, size);
    }

    private SpongeArchetypeVolume(Vector3i start, Vector3i size, Palette<Biome, Biome> biomePalette) {
        super(start, size);
        ArrayMutableBlockBuffer blocks;
        this.blocks = blocks = new ArrayMutableBlockBuffer(start, size);
        this.blockEntities = new MutableMapBlockEntityArchetypeBuffer(blocks);
        this.biomes = new ByteArrayMutableBiomeBuffer(biomePalette.asImmutable().asMutable(Sponge.server()), start, size);
        this.entities = new ObjectArrayMutableEntityArchetypeBuffer(start, size);
    }

    @Override
    public Optional<BlockEntityArchetype> blockEntityArchetype(int x, int y, int z) {
        return this.blockEntities.blockEntityArchetype(x, y, z);
    }

    @Override
    public Map<Vector3i, BlockEntityArchetype> blockEntityArchetypes() {
        return this.blockEntities.blockEntityArchetypes();
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockEntityArchetype> blockEntityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Stream stateStream = this.blockEntities.blockEntityArchetypeStream(min, max, options).toStream().map(element -> VolumeElement.of(this, element::type, element.position()));
        return new SpongeVolumeStream<ArchetypeVolume, BlockEntityArchetype>(stateStream, () -> this);
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes() {
        return this.entities.entityArchetypes();
    }

    @Override
    public Collection<EntityArchetypeEntry> entityArchetypesByPosition() {
        return this.entities.entityArchetypesByPosition();
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes(Predicate<EntityArchetype> filter) {
        return this.entities.entityArchetypes(filter);
    }

    @Override
    public VolumeStream<ArchetypeVolume, EntityArchetype> entityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Stream stateStream = this.entities.entityArchetypeStream(min, max, options).toStream().map(element -> VolumeElement.of(this, element::type, element.position()));
        return new SpongeVolumeStream<ArchetypeVolume, EntityArchetype>(stateStream, () -> this);
    }

    @Override
    public Stream<EntityArchetypeEntry> entitiesByPosition() {
        return this.entities.entitiesByPosition();
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.blockEntities.setBlock(x, y, z, block);
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return this.blockEntities.removeBlock(x, y, z);
    }

    @Override
    public BlockState block(int x, int y, int z) {
        return this.blocks.block(x, y, z);
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        return this.blocks.fluid(x, y, z);
    }

    @Override
    public int highestYAt(int x, int z) {
        return this.blocks.highestYAt(x, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? this.blocks.copy() : this.blocks;
        Stream stateStream = IntStream.range(min.x(), max.x() + 1).mapToObj(x -> IntStream.range(min.z(), max.z() + 1).mapToObj(z -> IntStream.range(min.y(), max.y() + 1).mapToObj(y -> VolumeElement.of(this, () -> buffer.block(x, y, z), new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ArchetypeVolume, BlockState>(stateStream, () -> this);
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
        this.blockEntities.addBlockEntity(x, y, z, archetype);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.blockEntities.removeBlockEntity(x, y, z);
    }

    public Palette<BlockState, BlockType> getBlockPalette() {
        return this.blocks.getPalette();
    }

    public Palette<Biome, Biome> getBiomePalette() {
        return this.biomes.getPalette();
    }

    @Override
    public void addEntity(EntityArchetypeEntry entry) {
        this.entities.addEntity(entry);
    }

    @Override
    public Biome biome(int x, int y, int z) {
        return this.biomes.biome(x, y, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Stream stateStream = this.biomes.biomeStream(min, max, options).toStream().map(element -> VolumeElement.of(this, element::type, element.position()));
        return new SpongeVolumeStream<ArchetypeVolume, Biome>(stateStream, () -> this);
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        return this.biomes.setBiome(x, y, z, biome);
    }

    @Override
    public ArchetypeVolume transform(Transformation transformation) {
        return new ReferentArchetypeVolume(this, Objects.requireNonNull(transformation, "Transformation cannot be null"));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void applyToWorld(ServerWorld target, Vector3i placement, Supplier<SpawnType> spawnContext) {
        Objects.requireNonNull(target, "Target world cannot be null");
        Objects.requireNonNull(placement, "Target position cannot be null");
        try (@NonNull P context = PluginPhase.State.VOLUME_STREAM_APPLICATION.createPhaseContext(PhaseTracker.SERVER).spawnType(spawnContext).source(this);){
            ((PhaseContext)context).buildAndSwitch();
            this.blockStateStream(this.min(), this.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(target, VolumePositionTranslators.relativeTo(placement), VolumeApplicators.applyBlocks(BlockChangeFlags.DEFAULT_PLACEMENT)));
            this.biomeStream(this.min(), this.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(target, VolumePositionTranslators.relativeTo(placement), VolumeApplicators.applyBiomes()));
            this.blockEntityArchetypeStream(this.min(), this.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(target, VolumePositionTranslators.relativeTo(placement), VolumeApplicators.applyBlockEntityArchetype()));
            this.entityArchetypeStream(this.min(), this.max(), StreamOptions.lazily()).apply(VolumeCollectors.of(target, VolumePositionTranslators.relativeTo(placement), VolumeApplicators.applyEntityArchetype()));
        }
    }
}

