/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.block;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.util.Mth;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface BlockBackingData {
    public int get(int var1);

    public void set(int var1, int var2);

    public BlockBackingData copyOf();

    public int getMax();

    public static class PackedBackingData
    implements BlockBackingData {
        private final long[] longArray;
        private final int bits;
        private final long maxValue;
        private final int arraySize;

        public PackedBackingData(int size, int highestValue) {
            this.arraySize = size;
            int bits = 0;
            while (1 << bits <= highestValue) {
                ++bits;
            }
            this.bits = bits;
            this.maxValue = (1 << bits) - 1;
            this.longArray = new long[Mth.roundUp((int)(size * bits), (int)64) / 64];
        }

        private PackedBackingData(int size, int bits, long[] array) {
            this.arraySize = size;
            this.bits = bits;
            this.maxValue = (1 << bits) - 1;
            this.longArray = array;
        }

        @Override
        public void set(int index, int value) {
            int bitIndex = index * this.bits;
            int longIndex = bitIndex / 64;
            int bitOffset = bitIndex % 64;
            this.longArray[longIndex] = this.longArray[longIndex] & (this.maxValue << bitOffset ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << bitOffset;
            if (bitOffset + this.bits > 64) {
                int bitsInLeft = 64 - bitOffset;
                int bitsInRight = this.bits - bitsInLeft;
                this.longArray[++longIndex] = this.longArray[longIndex] >>> bitsInRight << bitsInRight | (long)value >> bitsInLeft;
            }
        }

        @Override
        public int get(int index) {
            int bitIndex = index * this.bits;
            int longIndex = bitIndex / 64;
            int rightLongIndex = (bitIndex + this.bits - 1) / 64;
            int bitOffset = bitIndex % 64;
            if (bitOffset + this.bits > 64) {
                int bitsInLeft = 64 - bitOffset;
                return (int)((this.longArray[longIndex] >>> bitOffset | this.longArray[rightLongIndex] << bitsInLeft) & this.maxValue);
            }
            return (int)(this.longArray[longIndex] >>> bitOffset & this.maxValue);
        }

        @Override
        public PackedBackingData copyOf() {
            return new PackedBackingData(this.arraySize, this.bits, (long[])this.longArray.clone());
        }

        @Override
        public int getMax() {
            return (int)this.maxValue;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackedBackingData that = (PackedBackingData)o;
            return this.bits == that.bits && this.maxValue == that.maxValue && this.arraySize == that.arraySize && Arrays.equals(this.longArray, that.longArray);
        }

        public int hashCode() {
            int result = Objects.hash(this.bits, this.maxValue, this.arraySize);
            result = 31 * result + Arrays.hashCode(this.longArray);
            return result;
        }
    }

    public static class CharBackingData
    implements BlockBackingData {
        private final char[] data;

        public CharBackingData(char[] data) {
            this.data = data;
        }

        @Override
        public int get(int index) {
            return this.data[index];
        }

        @Override
        public void set(int index, int val) {
            this.data[index] = (char)val;
        }

        @Override
        public BlockBackingData copyOf() {
            return new CharBackingData((char[])this.data.clone());
        }

        @Override
        public int getMax() {
            return 65535;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharBackingData that = (CharBackingData)o;
            return Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

