/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.jar.JarFile;
import org.tinylog.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Agent {
    private static Instrumentation instrumentation;
    private static final Method URL_CLASS_LOADER_ADD_URL;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        Agent.instrumentation = instrumentation;
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        Agent.instrumentation = instrumentation;
    }

    static void addJarToClasspath(Path jar) {
        ClassLoader systemLoader;
        if (instrumentation != null) {
            try {
                instrumentation.appendToSystemClassLoaderSearch(new JarFile(jar.toRealPath(new LinkOption[0]).toString()));
                return;
            }
            catch (IOException ex) {
                Logger.error((Throwable)ex, "Failed to create jar file for archive '{}'!", jar);
            }
        }
        if ((systemLoader = ClassLoader.getSystemClassLoader()) instanceof URLClassLoader && URL_CLASS_LOADER_ADD_URL != null) {
            try {
                URL_CLASS_LOADER_ADD_URL.invoke((Object)systemLoader, jar.toRealPath(new LinkOption[0]).toUri().toURL());
                return;
            }
            catch (IOException | IllegalAccessException | InvocationTargetException ex) {
                Logger.error((Throwable)ex, "Failed to add path {} to the system ClassLoader", jar);
            }
        }
        throw new IllegalStateException("No agent was registered, and could not reflectively add the URL to the system URLClassLoader!");
    }

    static void crackModules() {
    }

    static {
        Method addUrl;
        try {
            addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrl.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            addUrl = null;
        }
        URL_CLASS_LOADER_ADD_URL = addUrl;
    }
}

