/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings.sponge;

import co.aikar.timings.Timing;
import co.aikar.timings.sponge.SpongeTimingsFactory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.registry.RegistryTypes;

public final class SpongeTimings {
    private SpongeTimings() {
    }

    public static Timing entityTiming(EntityType<?> type) {
        return SpongeTimingsFactory.ofSafe("Minecraft", "## entity - " + EntityType.getKey(type));
    }

    public static Timing blockEntityTiming(BlockEntityType<?> type) {
        return SpongeTimingsFactory.ofSafe("Minecraft", "## blockEntity - " + BlockEntityType.getKey(type));
    }

    public static Timing blockTiming(BlockType block) {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.BLOCK_TYPE).valueKey(block);
        return SpongeTimingsFactory.ofSafe("## Scheduled Block: " + resourceKey);
    }
}

