/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings.sponge;

import co.aikar.timings.sponge.TimingData;
import co.aikar.timings.sponge.TimingHandler;
import co.aikar.timings.sponge.TimingHistoryEntry;
import co.aikar.timings.sponge.TimingsManager;
import co.aikar.timings.util.JSONUtil;
import co.aikar.timings.util.LoadingMap;
import co.aikar.timings.util.MRUMapCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.common.SpongeCommon;

public class TimingHistory {
    public static long lastMinuteTime;
    public static long timedTicks;
    public static long playerTicks;
    public static long entityTicks;
    public static long blockEntityTicks;
    public static long activatedEntityTicks;
    static int worldIdPool;
    static Map<String, Integer> worldMap;
    final long endTime;
    final long startTime;
    final long totalTicks;
    final long totalTime;
    final MinuteReport[] minuteReports;
    final TimingHistoryEntry[] entries;
    final Set<BlockEntityType> tileEntityTypeSet = Sets.newHashSet();
    final Set<EntityType<?>> entityTypeSet = Sets.newHashSet();

    TimingHistory() {
        this.endTime = System.currentTimeMillis() / 1000L;
        this.startTime = TimingsManager.historyStart / 1000L;
        if (timedTicks % 1200L != 0L || TimingsManager.MINUTE_REPORTS.isEmpty()) {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size() + 1]);
            this.minuteReports[this.minuteReports.length - 1] = new MinuteReport();
        } else {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size()]);
        }
        long ticks = 0L;
        for (MinuteReport mp : this.minuteReports) {
            ticks += mp.ticksRecord.timed;
        }
        this.totalTicks = ticks;
        this.totalTime = TimingsManager.FULL_SERVER_TICK.record.getTotalTime();
        this.entries = new TimingHistoryEntry[TimingsManager.HANDLERS.size()];
        int i = 0;
        for (TimingHandler handler : TimingsManager.HANDLERS) {
            this.entries[i++] = new TimingHistoryEntry(handler);
        }
    }

    public static void resetTicks(boolean fullReset) {
        if (fullReset) {
            timedTicks = 0L;
        }
        lastMinuteTime = System.nanoTime();
        playerTicks = 0L;
        blockEntityTicks = 0L;
        entityTicks = 0L;
        activatedEntityTicks = 0L;
    }

    JsonObject export() {
        return JSONUtil.objectBuilder().add("s", (Object)this.startTime).add("e", (Object)this.endTime).add("tk", (Object)this.totalTicks).add("tm", (Object)this.totalTime).add("h", (Object)JSONUtil.mapArray(this.entries, entry -> entry.data.count == 0 ? null : entry.export())).add("mp", (Object)JSONUtil.mapArray(this.minuteReports, MinuteReport::export)).build();
    }

    static {
        worldIdPool = 1;
        worldMap = LoadingMap.newHashMap(input -> worldIdPool++);
    }

    static class MinuteReport {
        final long time = System.currentTimeMillis() / 1000L;
        final TicksRecord ticksRecord = new TicksRecord();
        final PingRecord pingRecord = new PingRecord();
        final TimingData fst;
        final double tps;
        final double usedMemory;
        final double freeMemory;
        final double loadAvg;

        MinuteReport() {
            this.fst = TimingsManager.FULL_SERVER_TICK.minuteData.clone();
            this.tps = 1.0E9 / (double)(System.nanoTime() - lastMinuteTime) * (double)this.ticksRecord.timed;
            this.usedMemory = TimingsManager.FULL_SERVER_TICK.avgUsedMemory;
            this.freeMemory = TimingsManager.FULL_SERVER_TICK.avgFreeMemory;
            this.loadAvg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        }

        public JsonArray export() {
            return JSONUtil.arrayOf(this.time, (double)Math.round(this.tps * 100.0) / 100.0, (double)Math.round(this.pingRecord.avg * 100.0) / 100.0, this.fst.export(), JSONUtil.arrayOf(this.ticksRecord.timed, this.ticksRecord.player, this.ticksRecord.entity, this.ticksRecord.activatedEntity, this.ticksRecord.tileEntity), this.usedMemory, this.freeMemory, this.loadAvg);
        }
    }

    static class TicksRecord {
        final long timed = timedTicks - (long)(TimingsManager.MINUTE_REPORTS.size() * 1200);
        final long player = playerTicks;
        final long entity = entityTicks;
        final long tileEntity = blockEntityTicks;
        final long activatedEntity = activatedEntityTicks;

        TicksRecord() {
        }
    }

    static class Counter {
        int count = 0;
        private static final Function<?, Counter> LOADER = new LoadingMap.Feeder<Counter>(){

            @Override
            public Counter apply() {
                return new Counter();
            }
        };

        Counter() {
        }

        static <T> Function<T, Counter> loader() {
            return LOADER;
        }

        public int increment() {
            return ++this.count;
        }

        public int count() {
            return this.count;
        }
    }

    static class PingRecord {
        final double avg;

        PingRecord() {
            Collection<ServerPlayer> onlinePlayers = SpongeCommon.game().server().onlinePlayers();
            int totalPing = 0;
            for (ServerPlayer player : onlinePlayers) {
                totalPing += player.connection().latency();
            }
            this.avg = onlinePlayers.isEmpty() ? 0.0 : (double)(totalPing / onlinePlayers.size());
        }
    }

    static class RegionData {
        final RegionId regionId;
        static Function<RegionId, RegionData> LOADER = new Function<RegionId, RegionData>(){

            @Override
            public RegionData apply(RegionId id) {
                return new RegionData(id);
            }
        };
        final Map<EntityType<?>, Counter> entityCounts = MRUMapCache.of(LoadingMap.of(Maps.newHashMap(), Counter.loader()));
        final Map<BlockEntityType, Counter> tileEntityCounts = MRUMapCache.of(LoadingMap.of(Maps.newHashMap(), Counter.loader()));

        RegionData(RegionId id) {
            this.regionId = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegionData that = (RegionData)o;
            return this.regionId.equals(that.regionId);
        }

        public int hashCode() {
            return this.regionId.hashCode();
        }

        static class RegionId {
            final int x;
            final int z;
            final long regionId;

            RegionId(int x, int z) {
                this.x = x >> 5 << 5;
                this.z = z >> 5 << 5;
                this.regionId = ((long)this.x << 32) + (long)(this.z >> 5 << 5) - Integer.MIN_VALUE;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RegionId regionId1 = (RegionId)o;
                return this.regionId == regionId1.regionId;
            }

            public int hashCode() {
                return (int)(this.regionId ^ this.regionId >>> 32);
            }
        }
    }
}

