/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings.sponge;

import co.aikar.timings.sponge.TimingData;
import co.aikar.timings.sponge.TimingHandler;
import co.aikar.timings.util.JSONUtil;
import com.google.gson.JsonArray;

class TimingHistoryEntry {
    final TimingData data;
    final TimingData[] children;

    TimingHistoryEntry(TimingHandler handler) {
        this.data = handler.record.clone();
        this.children = new TimingData[handler.children.size()];
        int i = 0;
        for (TimingData child : handler.children.values()) {
            this.children[i++] = child.clone();
        }
    }

    JsonArray export() {
        JsonArray result = this.data.export();
        if (this.children.length > 0) {
            result.add(JSONUtil.mapArray(this.children, TimingData::export));
        }
        return result;
    }
}

