/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings.sponge;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import co.aikar.timings.sponge.FullServerTickHandler;
import co.aikar.timings.sponge.SpongeTimingsFactory;
import co.aikar.timings.sponge.TimingHandler;
import co.aikar.timings.sponge.TimingHistory;
import co.aikar.timings.sponge.TimingIdentifier;
import co.aikar.timings.sponge.UnsafeTimingHandler;
import co.aikar.timings.util.LoadingMap;
import com.google.common.collect.EvictingQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.spongepowered.common.SpongeCommon;

public final class TimingsManager {
    static final Map<TimingIdentifier, TimingHandler> TIMING_MAP = Collections.synchronizedMap(LoadingMap.newHashMap(id -> id.protect ? new UnsafeTimingHandler((TimingIdentifier)id) : new TimingHandler((TimingIdentifier)id), 256, 0.5f));
    public static final FullServerTickHandler FULL_SERVER_TICK = new FullServerTickHandler();
    public static final TimingHandler TIMINGS_TICK = SpongeTimingsFactory.ofSafe("Timings Tick", FULL_SERVER_TICK);
    public static List<String> hiddenConfigs = new ArrayList<String>();
    public static boolean privacy = false;
    static final Collection<TimingHandler> HANDLERS = new ArrayDeque<TimingHandler>();
    static final ArrayDeque<TimingHistory.MinuteReport> MINUTE_REPORTS = new ArrayDeque();
    static EvictingQueue<TimingHistory> HISTORY = EvictingQueue.create((int)12);
    static TimingHandler CURRENT;
    static long timingStart;
    static long historyStart;
    static boolean needsFullReset;
    static boolean needsRecheckEnabled;

    private TimingsManager() {
    }

    static void reset() {
        needsFullReset = true;
    }

    static void tick() {
        if (Timings.isTimingsEnabled()) {
            boolean violated = FULL_SERVER_TICK.isViolated();
            for (TimingHandler handler : HANDLERS) {
                if (handler.isSpecial()) continue;
                handler.processTick(violated);
            }
            TimingHistory.playerTicks += (long)SpongeCommon.game().server().onlinePlayers().size();
            ++TimingHistory.timedTicks;
        }
    }

    static void stopServer() {
        Timings.setTimingsEnabled(false);
        TimingsManager.recheckEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recheckEnabled() {
        Map<TimingIdentifier, TimingHandler> map = TIMING_MAP;
        synchronized (map) {
            for (TimingHandler timings : TIMING_MAP.values()) {
                timings.checkEnabled();
            }
        }
        needsRecheckEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetTimings() {
        if (needsFullReset) {
            Map<TimingIdentifier, TimingHandler> map = TIMING_MAP;
            synchronized (map) {
                for (TimingHandler timings : TIMING_MAP.values()) {
                    timings.reset(true);
                }
            }
            if (timingStart != 0L) {
                SpongeCommon.logger().info("Timings reset");
            }
            HISTORY.clear();
            needsFullReset = false;
            needsRecheckEnabled = false;
            timingStart = System.currentTimeMillis();
        } else {
            for (TimingHandler timings : HANDLERS) {
                timings.reset(false);
            }
        }
        HANDLERS.clear();
        MINUTE_REPORTS.clear();
        TimingHistory.resetTicks(true);
        historyStart = System.currentTimeMillis();
    }

    static TimingHandler getHandler(String group, String name, Timing parent, boolean protect) {
        return TIMING_MAP.get(new TimingIdentifier(group, name, parent, protect));
    }

    static {
        timingStart = 0L;
        historyStart = 0L;
        needsFullReset = false;
        needsRecheckEnabled = false;
    }
}

