/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

public interface Subject
extends Contextual {
    public SubjectCollection containingCollection();

    public SubjectReference asSubjectReference();

    public Optional<?> associatedObject();

    @Override
    default public Cause contextCause() {
        Object associated = this.associatedObject().orElse(null);
        if (associated != null) {
            return Cause.of(EventContext.builder().add(EventContextKeys.SUBJECT, this).build(), associated);
        }
        return Contextual.super.contextCause();
    }

    public boolean isSubjectDataPersisted();

    public SubjectData subjectData();

    public SubjectData transientSubjectData();

    default public boolean hasPermission(String permission) {
        return this.hasPermission(permission, this.contextCause());
    }

    default public boolean hasPermission(String permission, Cause cause) {
        return this.permissionValue(permission, cause).asBoolean();
    }

    default public boolean hasPermission(String permission, Set<Context> contexts) {
        return this.permissionValue(permission, contexts).asBoolean();
    }

    default public Tristate permissionValue(String permission) {
        return this.permissionValue(permission, this.contextCause());
    }

    public Tristate permissionValue(String var1, Cause var2);

    public Tristate permissionValue(String var1, Set<Context> var2);

    default public boolean isChildOf(SubjectReference parent) {
        return this.isChildOf(parent, this.contextCause());
    }

    public boolean isChildOf(SubjectReference var1, Cause var2);

    public boolean isChildOf(SubjectReference var1, Set<Context> var2);

    default public List<? extends SubjectReference> parents() {
        return this.parents(this.contextCause());
    }

    public List<? extends SubjectReference> parents(Cause var1);

    public List<? extends SubjectReference> parents(Set<Context> var1);

    default public Optional<String> option(String key) {
        return this.option(key, this.contextCause());
    }

    public Optional<String> option(String var1, Cause var2);

    public Optional<String> option(String var1, Set<Context> var2);
}

