/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class DataSerializableTypeSerializer
implements TypeSerializer<DataSerializable> {
    private static final Class<DataSerializable> TYPE = DataSerializable.class;
    private final DataManager dataManager;

    public static boolean accepts(Type x) {
        return GenericTypeReflector.isSuperType(TYPE, x);
    }

    @Inject
    DataSerializableTypeSerializer(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    @Override
    public DataSerializable deserialize(Type type, ConfigurationNode value) throws SerializationException {
        Class<?> clazz = GenericTypeReflector.erase(type);
        return this.dataManager.deserialize(clazz.asSubclass(DataSerializable.class), ConfigurateTranslator.instance().translate(value)).orElseThrow(() -> new SerializationException("Could not translate DataSerializable of type: " + clazz.getName()));
    }

    @Override
    public void serialize(Type type, DataSerializable obj, ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.raw(null);
        } else {
            ConfigurateTranslator.instance().translateDataToNode(value, obj.toContainer());
        }
    }
}

