/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence.datastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.persistence.datastore.SpongeDataStore;
import org.spongepowered.common.data.persistence.datastore.VanillaDataStore;
import org.spongepowered.configurate.util.Types;

public final class SpongeDataStoreBuilder
implements DataStore.Builder,
DataStore.Builder.UpdaterStep,
DataStore.Builder.HolderStep,
DataStore.Builder.SerializersStep,
DataStore.Builder.EndStep {
    private final Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>> serializers = new IdentityHashMap();
    private final List<Type> dataHolderTypes = new ArrayList<Type>();
    private @Nullable ResourceKey key;
    private int version = 1;
    private DataContentUpdater[] updaters = new DataContentUpdater[0];

    @Override
    public <T, V extends Value<T>> SpongeDataStoreBuilder key(Key<V> key, DataQuery dataQuery) {
        BiFunction deserializer = this.getDeserializer(key.elementType());
        return this.key((Key)key, (T view, U value) -> view.set(dataQuery, value), (T v) -> (Optional)deserializer.apply((DataView)v, dataQuery));
    }

    public <T> BiFunction<DataView, DataQuery, Optional<T>> getDeserializer(Type elementType) {
        Class<?> rawType = GenericTypeReflector.erase(elementType);
        if (DataView.class.isAssignableFrom(rawType)) {
            return (view, dataQuery) -> view.getView((DataQuery)dataQuery);
        }
        if (DataSerializable.class.isAssignableFrom(rawType)) {
            return (view, dataQuery) -> view.getSerializable((DataQuery)dataQuery, rawType);
        }
        Optional registryTypeForValue = SpongeDataManager.INSTANCE.findRegistryTypeFor(rawType);
        if (registryTypeForValue.isPresent()) {
            return (view, dataQuery) -> registryTypeForValue.flatMap(regType -> view.getRegistryValue((DataQuery)dataQuery, regType));
        }
        if (ResourceKey.class.isAssignableFrom(rawType)) {
            return (view, dataQuery) -> view.getString((DataQuery)dataQuery).map(ResourceKey::resolve);
        }
        if (Sponge.game().dataManager().translator(rawType).isPresent()) {
            return (view, dataQuery) -> view.getObject((DataQuery)dataQuery, rawType);
        }
        if (Set.class.isAssignableFrom(rawType)) {
            Type listType = ((ParameterizedType)elementType).getActualTypeArguments()[0];
            return (view, dataQuery) -> SpongeDataStoreBuilder.deserializeList((Class)listType, view, dataQuery).map(list -> new HashSet(list));
        }
        if (List.class.isAssignableFrom(rawType)) {
            Type listType = ((ParameterizedType)elementType).getActualTypeArguments()[0];
            return (view, dataQuery) -> SpongeDataStoreBuilder.deserializeList((Class)listType, view, dataQuery);
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            throw new UnsupportedOperationException("Collection deserialization is not supported. Provide the deserializer for it.");
        }
        if (Types.isArray(elementType)) {
            Class<?> arrayType = GenericTypeReflector.erase(GenericTypeReflector.getArrayComponentType(elementType));
            return (view, dataQuery) -> SpongeDataStoreBuilder.deserializeList(arrayType, view, dataQuery).map(list -> this.listToArray(arrayType, (List)list));
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Function<DataQuery, Optional> keyDeserializer;
            Type[] parameterTypes = ((ParameterizedType)elementType).getActualTypeArguments();
            Type keyType = parameterTypes[0];
            Type valueType = parameterTypes[1];
            if (!(keyType instanceof Class)) {
                throw new UnsupportedOperationException("Unsupported map-key type " + keyType);
            }
            Optional registryTypeForKey = SpongeDataManager.INSTANCE.findRegistryTypeFor((Class)keyType);
            if (registryTypeForKey.isPresent()) {
                keyDeserializer = key -> registryTypeForKey.flatMap(regType -> Sponge.game().findRegistry(regType)).flatMap(r -> r.findValue(ResourceKey.resolve(key.toString())));
            } else if (((Class)keyType).isEnum()) {
                keyDeserializer = key -> Optional.ofNullable(Enum.valueOf((Class)keyType, key.toString()));
            } else if (keyType == String.class) {
                keyDeserializer = key -> Optional.of(key.toString());
            } else if (keyType == UUID.class) {
                keyDeserializer = key -> Optional.of(UUID.fromString(key.toString()));
            } else if (keyType == ResourceKey.class) {
                keyDeserializer = key -> Optional.of(ResourceKey.resolve(key.toString()));
            } else {
                throw new UnsupportedOperationException("Unsupported map-key type " + keyType);
            }
            BiFunction valueDeserializer = this.getDeserializer(valueType);
            return (view, dataQuery) -> view.getView((DataQuery)dataQuery).map(mapView -> {
                HashMap resultMap = new HashMap();
                for (DataQuery key : mapView.keys(false)) {
                    Object mapKey = ((Optional)keyDeserializer.apply(key)).orElseThrow(() -> new UnsupportedOperationException("Key not found " + key + " as " + keyType));
                    Optional mapValue = (Optional)valueDeserializer.apply((DataView)mapView, key);
                    resultMap.put(mapKey, mapValue.get());
                }
                return resultMap;
            });
        }
        return (view, dataQuery) -> view.get((DataQuery)dataQuery);
    }

    private static <T> Optional<List<T>> deserializeList(Class<T> listType, DataView view, DataQuery dataQuery) {
        if (DataView.class.isAssignableFrom(listType)) {
            return view.getViewList(dataQuery);
        }
        if (DataSerializable.class.isAssignableFrom(listType)) {
            return view.getSerializableList(dataQuery, listType);
        }
        Optional<List<T>> fromRegistry = SpongeDataManager.INSTANCE.findRegistryTypeFor(listType).flatMap(regType -> view.getRegistryValueList(dataQuery, regType));
        if (fromRegistry.isPresent()) {
            return fromRegistry;
        }
        if (Sponge.game().dataManager().translator(listType).isPresent()) {
            return view.getObjectList(dataQuery, listType);
        }
        return view.getList(dataQuery);
    }

    private <AT> AT[] listToArray(Class<AT> componentType, List<AT> list) {
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    public boolean isEmpty() {
        return this.serializers.isEmpty();
    }

    public List<Type> getDataHolderTypes() {
        return this.dataHolderTypes;
    }

    @Override
    public <T, V extends Value<T>> SpongeDataStoreBuilder key(Key<V> key, BiConsumer<DataView, T> serializer, Function<DataView, Optional<T>> deserializer) {
        if (this.key != null) {
            DataQuery query = DataQuery.of(this.key.namespace(), this.key.value());
            SpongeDataSerializer<T> customSerializer = new SpongeDataSerializer<T>(serializer, this.version, query);
            SpongeDataDeserializer<T> customDeserializer = new SpongeDataDeserializer<T>(deserializer, this.version, query);
            this.serializers.put(key, Tuple.of(customSerializer, customDeserializer));
        } else {
            this.serializers.put(key, Tuple.of(serializer, deserializer));
        }
        return this;
    }

    @Override
    public DataStore.Builder.EndStep keys(Key<?> key, Key<?> ... moreKeys) {
        this.key(key, key.key().value());
        for (Key<?> moreKey : moreKeys) {
            this.key(moreKey, moreKey.key().value());
        }
        return this;
    }

    @Override
    public DataStore.Builder reset() {
        this.serializers.clear();
        this.dataHolderTypes.clear();
        this.key = null;
        this.version = 1;
        this.updaters = new DataContentUpdater[0];
        return this;
    }

    @Override
    public SpongeDataStoreBuilder holder(TypeToken<? extends DataHolder> ... typeTokens) {
        for (TypeToken<? extends DataHolder> token : typeTokens) {
            this.dataHolderTypes.add(token.getType());
        }
        return this;
    }

    @Override
    public SpongeDataStoreBuilder holder(Class<? extends DataHolder> ... classes) {
        for (Class<? extends DataHolder> clazz : classes) {
            this.dataHolderTypes.add(Types.requireCompleteParameters(clazz));
        }
        return this;
    }

    @Override
    public SpongeDataStoreBuilder pluginData(ResourceKey key) {
        this.key = key;
        return this;
    }

    @Override
    public SpongeDataStoreBuilder pluginData(ResourceKey key, int version) {
        this.pluginData(key);
        this.version = version;
        return this;
    }

    @Override
    public DataStore.Builder.HolderStep updater(DataContentUpdater ... updaters) {
        this.updaters = updaters;
        return this;
    }

    @Override
    public SpongeDataStoreBuilder vanillaData() {
        this.key = null;
        return this;
    }

    @Override
    public DataStore build() {
        return new SpongeDataStore(this.key, (Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>>)ImmutableMap.copyOf(this.serializers), (Collection<Type>)ImmutableList.copyOf(this.dataHolderTypes), this.version, this.updaters);
    }

    public DataStore buildVanillaDataStore() {
        return new VanillaDataStore(Collections.unmodifiableMap(this.serializers), this.dataHolderTypes);
    }

    private static class SpongeDataSerializer<T>
    implements BiConsumer<DataView, T> {
        private final BiConsumer<DataView, T> serializer;
        private final DataQuery key;
        private final int version;

        public SpongeDataSerializer(BiConsumer<DataView, T> serializer, int version, DataQuery key) {
            this.serializer = serializer;
            this.key = key;
            this.version = version;
        }

        @Override
        public void accept(DataView view, T v) {
            DataView data = DataUtil.getSpongeData(view, this.key, this.version).orElse(DataContainer.createNew());
            this.serializer.accept(data, (DataView)v);
            if (data.isEmpty()) {
                return;
            }
            DataUtil.setSpongeData(view, this.key, data, this.version);
        }
    }

    private static class SpongeDataDeserializer<T>
    implements Function<DataView, Optional<T>> {
        private final Function<DataView, Optional<T>> deserializer;
        private final DataQuery key;
        private int version;

        public SpongeDataDeserializer(Function<DataView, Optional<T>> deserializer, int version, DataQuery key) {
            this.deserializer = deserializer;
            this.key = key;
            this.version = version;
        }

        @Override
        public Optional<T> apply(DataView view) {
            return DataUtil.getSpongeData(view, this.key, this.version).flatMap(this.deserializer);
        }
    }
}

