/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.key.SpongeKey;

public final class DataProviderLookup {
    private final Map<Key<?>, DataProvider<?, ?>> providerMap;

    DataProviderLookup(Map<Key<?>, DataProvider<?, ?>> providerMap) {
        this.providerMap = ImmutableMap.copyOf(providerMap);
    }

    public Collection<DataProvider<?, ?>> getAllProviders() {
        return this.providerMap.values();
    }

    public <V extends Value<E>, E> DataProvider<V, E> getProvider(Key<V> key) {
        return this.providerMap.getOrDefault(key, ((SpongeKey)key).getEmptyDataProvider());
    }
}

