/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;

class DelegateDataProvider<V extends Value<E>, E>
implements DataProvider<V, E> {
    private final Key<V> key;
    private final List<DataProvider<V, E>> providers;

    DelegateDataProvider(Key<V> key, List<DataProvider<V, E>> providers) {
        this.providers = providers;
        this.key = key;
    }

    @Override
    public Key<V> key() {
        return this.key;
    }

    @Override
    public boolean allowsAsynchronousAccess(DataHolder dataHolder) {
        return this.providers.stream().allMatch(provider -> provider.allowsAsynchronousAccess(dataHolder));
    }

    @Override
    public Optional<E> get(DataHolder dataHolder) {
        return this.providers.stream().map(provider -> provider.get(dataHolder)).filter(Optional::isPresent).findFirst().flatMap(optional -> optional);
    }

    @Override
    public boolean isSupported(DataHolder dataHolder) {
        return this.providers.stream().anyMatch(provider -> provider.isSupported(dataHolder));
    }

    @Override
    public boolean isSupported(Type dataHolder) {
        return this.providers.stream().anyMatch(provider -> provider.isSupported(dataHolder));
    }

    @Override
    public DataTransactionResult offer(DataHolder.Mutable dataHolder, E element) {
        return this.providers.stream().map(provider -> provider.offer(dataHolder, element)).filter(result -> result.type() != DataTransactionResult.Type.FAILURE).findFirst().orElseGet(() -> DataTransactionResult.errorResult(Value.immutableOf(this.key, element)));
    }

    @Override
    public DataTransactionResult remove(DataHolder.Mutable dataHolder) {
        return this.providers.stream().map(provider -> provider.remove(dataHolder)).filter(result -> result.type() != DataTransactionResult.Type.FAILURE).findFirst().orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public <I extends DataHolder.Immutable<I>> Optional<I> with(I immutable, E element) {
        return this.providers.stream().map(provider -> provider.with(immutable, element)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    @Override
    public <I extends DataHolder.Immutable<I>> Optional<I> without(I immutable) {
        return this.providers.stream().map(provider -> provider.without(immutable)).filter(Optional::isPresent).findFirst().orElseGet(() -> Optional.of(immutable));
    }
}

