/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.event.cause.entity.damage.SpongeDamageSources;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.PotionEffectUtil;
import org.spongepowered.math.vector.Vector3d;

public final class LivingData {
    private LivingData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(LivingEntity.class).create(Keys.ABSORPTION).get(h -> h.getAbsorptionAmount())).setAnd((h, v) -> {
            if (v < 0.0) {
                return false;
            }
            h.setAbsorptionAmount(v.floatValue());
            return true;
        })).create(Keys.ACTIVE_ITEM).get(h -> ItemStackUtil.snapshotOf(h.getUseItem()))).setAnd((h, v) -> {
            if (v.isEmpty()) {
                h.releaseUsingItem();
                return true;
            }
            return false;
        })).delete(LivingEntity::releaseUsingItem)).create(Keys.AUTO_SPIN_ATTACK_TICKS).get(h -> Ticks.of(((LivingEntityAccessor)h).accessor$autoSpinAttackTicks()))).set((h, v) -> h.startAutoSpinAttack((int)v.ticks()))).create(Keys.BODY_ROTATIONS).get(h -> {
            double headYaw = h.getYHeadRot();
            double pitch = h.getXRot();
            double yaw = h.getYRot();
            return ImmutableMap.of((Object)BodyParts.HEAD.get(), (Object)new Vector3d(pitch, headYaw, 0.0), (Object)BodyParts.CHEST.get(), (Object)new Vector3d(pitch, yaw, 0.0));
        })).set((h, v) -> {
            Vector3d headRotation = (Vector3d)v.get(BodyParts.HEAD.get());
            Vector3d bodyRotation = (Vector3d)v.get(BodyParts.CHEST.get());
            if (bodyRotation != null) {
                h.setYRot((float)bodyRotation.y());
                h.setXRot((float)bodyRotation.x());
            }
            if (headRotation != null) {
                h.yHeadRot = (float)headRotation.y();
                h.setXRot((float)headRotation.x());
            }
        })).create(Keys.CHEST_ROTATION).get(h -> new Vector3d(h.getXRot(), h.getYRot(), 0.0f))).set((h, v) -> {
            float yaw = (float)v.y();
            float pitch = (float)v.x();
            h.setYRot(yaw);
            h.setXRot(pitch);
        })).create(Keys.HEAD_ROTATION).get(h -> new Vector3d(h.getXRot(), h.getYHeadRot(), 0.0f))).set((h, v) -> {
            float headYaw = (float)v.y();
            float pitch = (float)v.x();
            h.setYHeadRot(headYaw);
            h.setXRot(pitch);
        })).create(Keys.HEALTH).get(h -> h.getHealth())).setAnd((h, v) -> {
            double maxHealth = h.getMaxHealth();
            if (v < 0.0 || v > maxHealth) {
                return false;
            }
            if (v == 0.0) {
                h.hurt((DamageSource)SpongeDamageSources.IGNORED, Float.MAX_VALUE);
            }
            h.setHealth(v.floatValue());
            return true;
        })).create(Keys.IS_AUTO_SPIN_ATTACK).get(LivingEntity::isAutoSpinAttack)).create(Keys.IS_ELYTRA_FLYING).get(LivingEntity::isFallFlying)).set((h, v) -> ((EntityAccessor)h).invoker$setSharedFlag(7, (boolean)v))).create(Keys.LAST_ATTACKER).get(h -> (Entity)h.getLastHurtByMob())).setAnd((h, v) -> {
            if (v instanceof LivingEntity) {
                h.setLastHurtByMob((LivingEntity)v);
                return true;
            }
            return false;
        })).delete(h -> h.setLastHurtByMob(null))).create(Keys.MAX_HEALTH).get(h -> h.getMaxHealth())).set((h, v) -> h.getAttribute(Attributes.MAX_HEALTH).setBaseValue(v.doubleValue()))).create(Keys.POTION_EFFECTS).get(h -> {
            Collection effects = h.getActiveEffects();
            return PotionEffectUtil.copyAsPotionEffects(effects);
        })).set((h, v) -> {
            h.removeAllEffects();
            for (PotionEffect effect : v) {
                h.addEffect(PotionEffectUtil.copyAsEffectInstance(effect));
            }
        })).create(Keys.SCALE).get(h -> h.getScale())).create(Keys.STUCK_ARROWS).get(LivingEntity::getArrowCount)).setAnd((h, v) -> {
            if (v < 0 || v > Integer.MAX_VALUE) {
                return false;
            }
            h.setArrowCount(v.intValue());
            return true;
        })).create(Keys.WALKING_SPEED).get(h -> h.getAttribute(Attributes.MOVEMENT_SPEED).getValue())).setAnd((h, v) -> {
            if (v < 0.0) {
                return false;
            }
            h.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(v.doubleValue());
            return true;
        })).asMutable(LivingEntityAccessor.class).create(Keys.LAST_DAMAGE_RECEIVED).get(h -> h.accessor$lastHurt())).set((h, v) -> h.accessor$lastHurt(v.floatValue()));
    }
}

