/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.leangen.geantyref.TypeToken;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.RegistryWriteOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeZoomer;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.datapack.DataPackSerializable;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.world.WorldTypeTemplate;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.datapack.DataPackSerializableSerializer;
import org.spongepowered.common.datapack.DataPackSerializedObject;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.TagDataPackSerializer;
import org.spongepowered.common.datapack.recipe.RecipeDataPackSerializer;
import org.spongepowered.common.datapack.recipe.RecipeSerializedObject;
import org.spongepowered.common.datapack.tag.TagSerializedObject;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.tag.SpongeTagTemplate;
import org.spongepowered.common.world.server.SpongeWorldTemplate;
import org.spongepowered.common.world.server.SpongeWorldTypeTemplate;

public final class SpongeDataPackType<T extends DataPackSerializable, U extends DataPackSerializedObject>
implements DataPackType<T> {
    private final TypeToken<T> token;
    private final DataPackSerializer<U> packSerializer;
    private final DataPackSerializableSerializer<T> objectSerializer;
    private final BiFunction<T, JsonObject, U> objectFunction;
    private final boolean persistent;

    public SpongeDataPackType(TypeToken<T> token, DataPackSerializer<U> packSerializer, DataPackSerializableSerializer<T> objectSerializer, BiFunction<T, JsonObject, U> objectFunction, boolean persistent) {
        this.token = token;
        this.packSerializer = packSerializer;
        this.objectSerializer = objectSerializer;
        this.objectFunction = objectFunction;
        this.persistent = persistent;
    }

    @Override
    public TypeToken<T> type() {
        return this.token;
    }

    @Override
    public boolean persistent() {
        return this.persistent;
    }

    public DataPackSerializer<U> getPackSerializer() {
        return this.packSerializer;
    }

    public DataPackSerializableSerializer<T> getObjectSerializer() {
        return this.objectSerializer;
    }

    public BiFunction<T, JsonObject, U> getObjectFunction() {
        return this.objectFunction;
    }

    public static final class FactoryImpl
    implements DataPackType.Factory {
        private final SpongeDataPackType<@NonNull Advancement, DataPackSerializedObject> advancement = new SpongeDataPackType<Advancement, DataPackSerializedObject>(TypeToken.get(Advancement.class), new DataPackSerializer("Advancements", "advancements"), s -> ((net.minecraft.advancements.Advancement)s).deconstruct().serializeToJson(), (i1, i2) -> new DataPackSerializedObject(i1.key(), (JsonObject)i2), false);
        private final SpongeDataPackType<@NonNull RecipeRegistration, RecipeSerializedObject> recipe = new SpongeDataPackType<RecipeRegistration, RecipeSerializedObject>(TypeToken.get(RecipeRegistration.class), new RecipeDataPackSerializer(), s -> ((FinishedRecipe)s).serializeRecipe(), (i1, i2) -> new RecipeSerializedObject(i1.key(), (JsonObject)i2, new DataPackSerializedObject(i1.key(), ((FinishedRecipe)i1).serializeAdvancement())), false);
        private final SpongeDataPackType<@NonNull WorldTypeTemplate, DataPackSerializedObject> worldType = new SpongeDataPackType<WorldTypeTemplate, DataPackSerializedObject>(TypeToken.get(WorldTypeTemplate.class), new DataPackSerializer("Dimension Types", "dimension_type"), s -> {
            OptionalLong fixedTime = s.fixedTime().isEmpty() ? OptionalLong.empty() : OptionalLong.of(s.fixedTime().get().asTicks().ticks());
            DimensionType type = DimensionType.create((OptionalLong)fixedTime, (boolean)s.hasSkylight(), (boolean)s.hasCeiling(), (boolean)s.scorching(), (boolean)s.natural(), (double)s.coordinateMultiplier(), (boolean)s.createDragonFight(), (boolean)s.piglinSafe(), (boolean)s.bedsUsable(), (boolean)s.respawnAnchorsUsable(), (boolean)s.hasRaids(), (int)s.minY(), (int)s.logicalHeight(), (int)s.maximumHeight(), (BiomeZoomer)((BiomeZoomer)s.biomeSampler()), (ResourceLocation)((ResourceLocation)((SpongeWorldTypeTemplate)s).infiniburn), (ResourceLocation)((ResourceLocation)s.effect().key()), (float)s.ambientLighting());
            return (JsonElement)SpongeWorldTypeTemplate.DIRECT_CODEC.encodeStart((DynamicOps)RegistryWriteOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)BootstrapProperties.registries), (Object)type).getOrThrow(false, e -> {});
        }, (i1, i2) -> new DataPackSerializedObject(i1.key(), (JsonObject)i2), true);
        private final SpongeDataPackType<@NonNull WorldTemplate, DataPackSerializedObject> world = new SpongeDataPackType<WorldTemplate, DataPackSerializedObject>(TypeToken.get(WorldTemplate.class), new DataPackSerializer("Dimensions", "dimension"), s -> {
            LevelStem template = new LevelStem(() -> (DimensionType)BootstrapProperties.registries.registryOrThrow(Registry.DIMENSION_TYPE_REGISTRY).get((ResourceLocation)s.worldType().location()), (ChunkGenerator)s.generator());
            ((LevelStemBridge)template).bridge$setFromSettings(false);
            ((LevelStemBridge)template).bridge$populateFromTemplate((SpongeWorldTemplate)s);
            return (JsonElement)SpongeWorldTemplate.DIRECT_CODEC.encodeStart((DynamicOps)RegistryWriteOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)BootstrapProperties.registries), (Object)template).getOrThrow(false, e -> {});
        }, (i1, i2) -> new DataPackSerializedObject(i1.key(), (JsonObject)i2), true);
        private final SpongeDataPackType<@NonNull SpongeTagTemplate, TagSerializedObject> tag = new SpongeDataPackType<SpongeTagTemplate, TagSerializedObject>(TypeToken.get(SpongeTagTemplate.class), new TagDataPackSerializer("Tag", "tags"), s -> {
            JsonObject jsonObject = s.toJson();
            jsonObject.addProperty("replace", s.replace());
            return jsonObject;
        }, (i1, i2) -> new TagSerializedObject(i1.key(), (JsonObject)i2, i1.tagType()), false);

        @Override
        public DataPackType<RecipeRegistration> recipe() {
            return this.recipe;
        }

        @Override
        public DataPackType<Advancement> advancement() {
            return this.advancement;
        }

        @Override
        public DataPackType<WorldTypeTemplate> worldType() {
            return this.worldType;
        }

        @Override
        public DataPackType<WorldTemplate> world() {
            return this.world;
        }

        public DataPackType tag() {
            return this.tag;
        }
    }
}

