/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.tags.Tag;
import org.apache.commons.io.FileUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.SpongeDataPackType;
import org.spongepowered.common.datapack.tag.TagSerializedObject;
import org.spongepowered.common.tag.SpongeTagType;

public final class TagDataPackSerializer
extends DataPackSerializer<TagSerializedObject> {
    public TagDataPackSerializer(String token, String typeDirectoryName) {
        super(token, typeDirectoryName);
    }

    @Override
    protected boolean serialize(SpongeDataPackType<@NonNull ?, TagSerializedObject> type, Path datapacksDir, List<TagSerializedObject> objects, int count) throws IOException {
        Path datapackDir = datapacksDir.resolve(this.getPackName());
        if (!type.persistent()) {
            FileUtils.deleteDirectory((File)datapackDir.toFile());
        }
        if (objects.isEmpty()) {
            return false;
        }
        for (TagSerializedObject object : objects) {
            Path namespacedDataDirectory = datapackDir.resolve("data").resolve(object.getKey().namespace());
            String filename = object.getKey().value() + ".json";
            Path objectFile = namespacedDataDirectory.resolve(this.typeDirectoryName).resolve(((SpongeTagType)object.getTagType()).internalId()).resolve(filename);
            Files.createDirectories(objectFile.getParent(), new FileAttribute[0]);
            JsonObject toWrite = object.getObject();
            if (Files.exists(objectFile, new LinkOption[0]) && !object.getObject().getAsJsonPrimitive("replace").getAsBoolean()) {
                JsonObject jsonObject;
                try (BufferedReader bufferedReader = Files.newBufferedReader(objectFile);){
                    JsonElement jsonElement = new JsonParser().parse(bufferedReader);
                    jsonObject = jsonElement.getAsJsonObject();
                }
                toWrite = Tag.Builder.tag().addFromJson(jsonObject, filename).addFromJson(object.getObject(), filename).serializeToJson();
            }
            DataPackSerializer.writeFile(objectFile, toWrite);
            this.serializeAdditional(namespacedDataDirectory, object);
        }
        DataPackSerializer.writePackMetadata(this.name, datapackDir);
        return true;
    }
}

