/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import com.google.common.base.Preconditions;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.accessor.world.damagesource.DamageSourceAccessor;
import org.spongepowered.common.util.MinecraftBlockDamageSource;

public final class SpongeBlockDamageSourceBuilder
extends AbstractDamageSourceBuilder<BlockDamageSource, BlockDamageSource.Builder>
implements BlockDamageSource.Builder {
    private ServerLocation location;
    private BlockSnapshot blockSnapshot;

    @Override
    public BlockDamageSource.Builder block(ServerLocation location) {
        this.location = location;
        return this;
    }

    @Override
    public BlockDamageSource.Builder block(BlockSnapshot blockState) {
        this.blockSnapshot = (BlockSnapshot)Preconditions.checkNotNull((Object)blockState);
        return this;
    }

    @Override
    public BlockDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.location != null ? 1 : 0) != 0);
        Preconditions.checkState((this.blockSnapshot != null ? 1 : 0) != 0);
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0);
        MinecraftBlockDamageSource damageSource = new MinecraftBlockDamageSource(this.damageType.name(), this.location);
        DamageSourceAccessor accessor = (DamageSourceAccessor)((Object)damageSource);
        if (this.absolute) {
            accessor.invoker$bypassMagic();
        }
        if (this.bypasses) {
            accessor.invoker$bypassArmor();
        }
        if (this.scales) {
            damageSource.setScalesWithDifficulty();
        }
        if (this.explosion) {
            damageSource.setExplosion();
        }
        if (this.magical) {
            damageSource.setMagic();
        }
        if (this.creative) {
            accessor.invoker$bypassInvul();
        }
        if (this.exhaustion != null) {
            accessor.accessor$exhaustion(this.exhaustion.floatValue());
        }
        if (this.fire) {
            accessor.invoker$setIsFire();
        }
        return (BlockDamageSource)((Object)damageSource);
    }

    @Override
    public BlockDamageSource.Builder reset() {
        super.reset();
        this.location = null;
        this.blockSnapshot = null;
        return this;
    }
}

