/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.source.IndirectEntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.common.accessor.world.damagesource.DamageSourceAccessor;

public final class SpongeIndirectEntityDamageSourceBuilder
extends AbstractDamageSourceBuilder<IndirectEntityDamageSource, IndirectEntityDamageSource.Builder>
implements IndirectEntityDamageSource.Builder {
    protected WeakReference<Entity> reference = null;
    private WeakReference<Entity> proxy = null;

    @Override
    public IndirectEntityDamageSource.Builder proxySource(Entity projectile) {
        this.proxy = new WeakReference<Entity>(projectile);
        return this;
    }

    @Override
    public IndirectEntityDamageSource.Builder entity(Entity entity) {
        this.reference = new WeakReference<Entity>(entity);
        return this;
    }

    @Override
    public IndirectEntityDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.reference.get() != null ? 1 : 0) != 0);
        Preconditions.checkState((this.proxy.get() != null ? 1 : 0) != 0);
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0);
        net.minecraft.world.damagesource.IndirectEntityDamageSource damageSource = new net.minecraft.world.damagesource.IndirectEntityDamageSource(this.damageType.name(), (net.minecraft.world.entity.Entity)this.reference.get(), (net.minecraft.world.entity.Entity)this.proxy.get());
        DamageSourceAccessor accessor = (DamageSourceAccessor)damageSource;
        if (this.creative) {
            accessor.invoker$bypassInvul();
        }
        if (this.scales) {
            damageSource.setScalesWithDifficulty();
        }
        if (this.magical) {
            damageSource.setMagic();
        }
        if (this.bypasses) {
            accessor.invoker$bypassArmor();
        }
        if (this.absolute) {
            accessor.invoker$bypassMagic();
        }
        if (this.explosion) {
            damageSource.setExplosion();
        }
        if (this.exhaustion != null) {
            accessor.accessor$exhaustion(this.exhaustion.floatValue());
        }
        return (IndirectEntityDamageSource)damageSource;
    }

    @Override
    public IndirectEntityDamageSource.Builder from(IndirectEntityDamageSource value) {
        super.from(value);
        this.reference = new WeakReference<Entity>(value.source());
        this.proxy = new WeakReference<Entity>(value.indirectSource());
        return this;
    }

    @Override
    public IndirectEntityDamageSource.Builder reset() {
        super.reset();
        this.reference = null;
        this.proxy = null;
        return this;
    }
}

