/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.ICaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.DeepIterator;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.EventByTransaction;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.ReverseDeepIterator;
import org.spongepowered.common.event.tracking.context.transaction.StatefulTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.TransactionSink;
import org.spongepowered.common.event.tracking.context.transaction.effect.PrepareBlockDrops;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;

public final class TransactionalCaptureSupplier
implements ICaptureSupplier,
TransactionSink,
Iterable<GameTransaction<?>> {
    private @Nullable GameTransaction<@NonNull ?> tail;
    private @Nullable GameTransaction<@NonNull ?> head;
    private @Nullable ResultingTransactionBySideEffect effect;
    private final PhaseContext<@NonNull ?> context;

    public TransactionalCaptureSupplier(PhaseContext<@NonNull ?> context) {
        this.context = context;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public EffectTransactor pushEffect(ResultingTransactionBySideEffect effect) {
        GameTransaction<@NonNull ?> parentTransaction = Optional.ofNullable(this.effect).map(child -> child.tail).orElse(Objects.requireNonNull(this.tail, "Somehow pushing a new effect without an owning Transaction"));
        EffectTransactor effectTransactor = new EffectTransactor(effect, parentTransaction, this.effect, this);
        this.effect = effect;
        parentTransaction.addLast(effect);
        return effectTransactor;
    }

    void popEffect(EffectTransactor transactor) {
        this.effect = transactor.previousEffect;
    }

    @Override
    @Deprecated
    public void logTransaction(StatefulTransaction transaction) {
        if (this.head == null) {
            GameTransaction<@NonNull ?> gameTransaction = transaction.recordState();
            this.head = gameTransaction;
            this.tail = gameTransaction;
            return;
        }
        Optional<TransactionFlow.AbsorbingFlowStep> absorbingFlowStep = transaction.parentAbsorber();
        if (absorbingFlowStep.isPresent()) {
            TransactionFlow.AbsorbingFlowStep absorber = absorbingFlowStep.get();
            Iterator<GameTransaction<@NonNull ?>> iterator = this.descendingIterator();
            while (iterator.hasNext()) {
                GameTransaction<@NonNull ?> next = iterator.next();
                if (!absorber.absorb(this.context, next)) continue;
                return;
            }
        }
        if (transaction.shouldHaveBeenAbsorbed()) {
            SpongeCommon.logger().warn("Logged transaction without event transaction!", (Throwable)new Exception(transaction.getClass().getName()));
        }
        GameTransaction<@NonNull ?> gameTransaction = transaction.recordState();
        if (this.effect != null) {
            this.effect.addChild(this.context, gameTransaction);
        } else {
            gameTransaction.previous = this.tail;
            if (this.tail != null) {
                this.tail.next = gameTransaction;
            }
            this.tail = gameTransaction;
        }
    }

    public void completeBlockDrops(@Nullable EffectTransactor context) {
        if (this.effect != null && this.effect.effect == PrepareBlockDrops.getInstance() && context != null) {
            context.close();
        }
    }

    public void clear() {
        this.head = null;
        this.tail = null;
        this.effect = null;
    }

    public boolean processTransactions(PhaseContext<@NonNull ?> context) {
        if (this.head == null) {
            return false;
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableList<EventByTransaction<@NonNull ?>> batched = TransactionalCaptureSupplier.batchTransactions(this.head, null, context, (ImmutableMultimap.Builder<TransactionType, ? extends Event>)builder);
        boolean cancelledAny = false;
        for (EventByTransaction eventWithTransactions : batched) {
            Object event = eventWithTransactions.event;
            if (eventWithTransactions.isParentOrDeciderCancelled()) {
                cancelledAny = true;
                eventWithTransactions.markCancelled();
                continue;
            }
            Sponge.eventManager().post((Event)event);
            if (event instanceof Cancellable && ((Cancellable)event).isCancelled()) {
                eventWithTransactions.markCancelled();
                cancelledAny = true;
            }
            if (eventWithTransactions.decider.markCancelledTransactions(event, eventWithTransactions.transactions)) {
                cancelledAny = true;
            }
            for (GameTransaction transaction : eventWithTransactions.transactions) {
                if (transaction.cancelled) {
                    transaction.markEventAsCancelledIfNecessary(eventWithTransactions.event);
                }
                if (transaction.cancelled) continue;
                transaction.postProcessEvent(context, event);
            }
        }
        if (cancelledAny) {
            for (EventByTransaction eventByTransaction : batched.reverse()) {
                if (eventByTransaction.decider.cancelled) {
                    eventByTransaction.decider.markEventAsCancelledIfNecessary(eventByTransaction.event);
                }
                for (GameTransaction gameTransaction : eventByTransaction.transactions.reverse()) {
                    if (!gameTransaction.cancelled) continue;
                    gameTransaction.restore(context, eventByTransaction.event);
                }
            }
        }
        builder.build().asMap().forEach((transactionType, events) -> transactionType.createAndProcessPostEvents(context, events));
        return !cancelledAny;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static ImmutableList<EventByTransaction<@NonNull ?>> batchTransactions(GameTransaction head, @Nullable GameTransaction parent, PhaseContext<@NonNull ?> context, ImmutableMultimap.Builder<TransactionType, ? extends Event> transactionPostEventBuilder) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableList.Builder builder = ImmutableList.builder();
        GameTransaction<?> pointer = head;
        ImmutableList.Builder accumilator = ImmutableList.builder();
        GameTransaction<?> batchDecider = null;
        while (pointer != null) {
            ImmutableList transactions;
            if (batchDecider == null) {
                batchDecider = pointer;
            }
            if (batchDecider.shouldBuildEventAndRestartBatch(pointer, context)) {
                transactions = accumilator.build();
                accumilator = ImmutableList.builder();
                TransactionalCaptureSupplier.generateEventForTransaction(batchDecider, parent, context, builder, transactions, transactionPostEventBuilder);
                batchDecider = pointer;
                continue;
            }
            if (pointer.hasAnyPrimaryChildrenTransactions() || pointer.isUnbatchable() || pointer.next == null) {
                accumilator.add((Object)pointer);
                transactions = accumilator.build();
                accumilator = ImmutableList.builder();
                batchDecider = pointer.next;
                TransactionalCaptureSupplier.generateEventForTransaction(pointer, parent, context, builder, transactions, transactionPostEventBuilder);
            } else {
                accumilator.add((Object)pointer);
            }
            pointer = pointer.next;
        }
        ImmutableList remaining = accumilator.build();
        if (!remaining.isEmpty()) {
            TransactionalCaptureSupplier.generateEventForTransaction(Objects.requireNonNull(batchDecider, "BatchDeciding Transaction was null"), parent, context, builder, remaining, transactionPostEventBuilder);
        }
        return builder.build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static <E extends Event & Cancellable> void generateEventForTransaction(@NonNull GameTransaction<E> pointer, @Nullable GameTransaction<@NonNull ?> parent, PhaseContext<@NonNull ?> context, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<EventByTransaction<@NonNull ?>> builder, ImmutableList<GameTransaction<E>> transactions, ImmutableMultimap.Builder<TransactionType, ? extends Event> transactionPostEventBuilder) {
        Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> frameMutator = pointer.getFrameMutator(parent);
        PhaseTracker instance = PhaseTracker.getInstance();
        try (CauseStackManager.StackFrame frame = frameMutator.map(mutator -> {
            CauseStackManager.StackFrame transactionFrame = instance.pushCauseFrame();
            mutator.accept(context, transactionFrame);
            return transactionFrame;
        }).orElseGet(instance::pushCauseFrame);){
            Optional<E> generatedEvent = pointer.generateEvent(context, parent, transactions, instance.currentCause());
            generatedEvent.ifPresent(e -> {
                EventByTransaction<@NonNull Event> element = new EventByTransaction<Event>((Event)e, (ImmutableList<GameTransaction<Event>>)transactions, parent, pointer);
                builder.add(element);
                transactionPostEventBuilder.put(pointer.getTransactionType(), e);
            });
            for (GameTransaction transaction : transactions) {
                if (transaction.sideEffects == null || transaction.sideEffects.isEmpty()) continue;
                generatedEvent.ifPresent(x$0 -> frame.pushCause(x$0));
                for (ResultingTransactionBySideEffect sideEffect : transaction.sideEffects) {
                    if (sideEffect.head == null) continue;
                    builder.addAll(TransactionalCaptureSupplier.batchTransactions(sideEffect.head, pointer, context, transactionPostEventBuilder));
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.head);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionalCaptureSupplier other = (TransactionalCaptureSupplier)obj;
        return Objects.equals(this.head, other.head);
    }

    public String toString() {
        return new StringJoiner(", ", TransactionalCaptureSupplier.class.getSimpleName() + "[", "]").add("tail=" + this.tail).add("head=" + this.head).add("effect=" + this.effect).toString();
    }

    public void reset() {
        if (this.head != null) {
            this.head = null;
            this.tail = null;
        }
        if (this.effect != null) {
            this.effect = null;
        }
    }

    @Override
    public Iterator<GameTransaction<@NonNull ?>> iterator() {
        return this.head != null ? new DeepIterator(this.head) : Collections.emptyIterator();
    }

    @Override
    public Spliterator<GameTransaction<@NonNull ?>> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 272);
    }

    public Iterator<GameTransaction<@NonNull ?>> descendingIterator() {
        return this.tail != null ? new ReverseDeepIterator(this.tail) : Collections.emptyIterator();
    }
}

