/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class AddBlockLootDropsEffect
implements ProcessingSideEffect {
    public static AddBlockLootDropsEffect getInstance() {
        return Holder.INSTANCE;
    }

    AddBlockLootDropsEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
        ServerLevel world = pipeline.getServerWorld();
        @Nullable BlockEntity existingTile = oldState.tileEntity;
        BlockPos pos = oldState.pos;
        LootContext.Builder lootBuilder = new LootContext.Builder(world).withRandom(world.random).withParameter(LootContextParams.ORIGIN, (Object)VecHelper.toVanillaVector3d(pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)existingTile);
        phaseContext.populateLootContext(lootBuilder);
        return new EffectResult(newState, oldState.state.getDrops(lootBuilder), false);
    }

    private static final class Holder {
        static final AddBlockLootDropsEffect INSTANCE = new AddBlockLootDropsEffect();

        private Holder() {
        }
    }
}

