/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SetPlayerContainerTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.PrettyPrinter;

public class OpenMenuTransaction
extends GameTransaction<InteractContainerEvent> {
    private final ServerPlayer player;
    private final ItemStackSnapshot cursor;
    private AbstractContainerMenu menu;

    public OpenMenuTransaction(Player player) {
        super(TransactionTypes.INTERACT_CONTAINER_EVENT.get());
        this.player = (ServerPlayer)player;
        this.menu = player.containerMenu;
        this.cursor = ItemStackUtil.snapshotOf(player.containerMenu.getCarried());
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> frame.pushCause(this.menu));
    }

    @Override
    public Optional<InteractContainerEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<InteractContainerEvent>> gameTransactions, Cause currentCause) {
        ItemStackSnapshot resultingCursor = ItemStackUtil.snapshotOf(this.player.containerMenu.getCarried());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(this.cursor, resultingCursor);
        InteractContainerEvent.Open event = SpongeEventFactory.createInteractContainerEventOpen(currentCause, (Container)this.menu, cursorTransaction);
        return Optional.of(event);
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        PacketPhaseUtil.handleCursorRestore((Player)this.player, event.cursorTransaction());
        this.player.closeContainer();
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        PacketPhaseUtil.handleCursorRestore((Player)this.player, event.cursorTransaction());
    }

    @Override
    public boolean markCancelledTransactions(InteractContainerEvent event, ImmutableList<? extends GameTransaction<InteractContainerEvent>> gameTransactions) {
        if (event.isCancelled()) {
            event.cursorTransaction().invalidate();
            return true;
        }
        return !event.cursorTransaction().isValid();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    public boolean absorbContainerSet(PhaseContext<@NonNull ?> ctx, SetPlayerContainerTransaction transaction) {
        if (this.player != transaction.player) {
            return false;
        }
        this.menu = transaction.menu;
        return true;
    }

    @Override
    public boolean absorbSlotTransaction(ContainerSlotTransaction slotTransaction) {
        return true;
    }
}

