/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;

final class BlockDropItemsPhaseState
extends BlockPhaseState {
    private final BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> BLOCK_DROP_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        BlockSnapshot blockSnapshot = ctx.getSource(BlockSnapshot.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a block dropping items!", ctx));
        frame.pushCause(blockSnapshot);
    });

    BlockDropItemsPhaseState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, GeneralizedContext> getFrameModifier() {
        return this.BLOCK_DROP_MODIFIER;
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(GeneralizedContext context, Entity entityToSpawn) {
        return SpawnTypes.DROPPED_ITEM;
    }

    @Override
    public void unwind(GeneralizedContext context) {
        TrackingUtil.processBlockCaptures(context);
    }
}

