/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.slot;

import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.common.inventory.adapter.impl.slots.EquipmentSlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.slot.FilteringSlotLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

public class EquipmentSlotLens
extends FilteringSlotLens {
    private final Predicate<EquipmentType> equipmentTypeFilter = e -> e == type;

    public EquipmentSlotLens(Lens parent, SlotLens lens, EquipmentType type) {
        super(lens, EquipmentSlotLens.equipmentTypeFilter(type), EquipmentSlotAdapter.class);
        this.setParent(parent);
    }

    private static FilteringSlotLens.ItemStackFilter equipmentTypeFilter(EquipmentType type) {
        return (fabric, item) -> {
            EquipmentSlot itemSlotType = Mob.getEquipmentSlotForItem((ItemStack)ItemStackUtil.toNative(item));
            return itemSlotType == type;
        };
    }

    public Predicate<EquipmentType> getEquipmentTypeFilter() {
        return this.equipmentTypeFilter;
    }

    @Override
    public Slot getAdapter(Fabric fabric, Inventory parent) {
        return new EquipmentSlotAdapter(fabric, this, parent);
    }
}

