/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.merchant;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackGenerator;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.api.item.merchant.TradeOfferGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;

public final class SpongeTradeOfferGenerator
implements TradeOfferGenerator {
    final ItemStackGenerator firstItemGenerator;
    final ItemStackGenerator sellingItemGenerator;
    final @Nullable ItemStackGenerator secondItemGenerator;
    final double experience;
    final VariableAmount baseUses;
    final VariableAmount maxUses;
    final VariableAmount grantedExperience;

    public static Builder builder() {
        return new Builder();
    }

    SpongeTradeOfferGenerator(Builder builder) {
        this.firstItemGenerator = builder.firstGenerator;
        this.secondItemGenerator = builder.secondGenerator;
        this.sellingItemGenerator = builder.sellingGenerator;
        this.experience = builder.experience;
        this.baseUses = builder.baseUses;
        this.maxUses = builder.maxUses;
        this.grantedExperience = builder.grantedExperience == null ? VariableAmount.fixed(0.0) : builder.grantedExperience;
    }

    @Override
    public TradeOffer apply(Entity merchant, Random random) {
        Objects.requireNonNull(random, "Random cannot be null!");
        TradeOffer.Builder builder = TradeOffer.builder();
        builder.firstBuyingItem((ItemStack)this.firstItemGenerator.apply(random));
        if (this.secondItemGenerator != null) {
            builder.secondBuyingItem((ItemStack)this.secondItemGenerator.apply(random));
        }
        builder.sellingItem((ItemStack)this.sellingItemGenerator.apply(random));
        if (random.nextDouble() < this.experience) {
            builder.merchantExperienceGranted(this.grantedExperience.flooredAmount(random));
        }
        builder.uses(this.baseUses.flooredAmount(random));
        builder.maxUses(this.maxUses.flooredAmount(random));
        return builder.build();
    }

    public static final class Builder
    implements TradeOfferGenerator.Builder {
        @MonotonicNonNull ItemStackGenerator firstGenerator;
        @Nullable ItemStackGenerator secondGenerator;
        @MonotonicNonNull ItemStackGenerator sellingGenerator;
        double experience;
        @MonotonicNonNull VariableAmount baseUses;
        @MonotonicNonNull VariableAmount maxUses;
        @Nullable VariableAmount grantedExperience;

        @Override
        public TradeOfferGenerator.Builder firstBuyingItemGenerator(ItemStackGenerator generator) {
            this.firstGenerator = Objects.requireNonNull(generator, "ItemStackGenerator cannot be null!");
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder secondBuyingItemGenerator(@Nullable ItemStackGenerator generator) {
            this.secondGenerator = generator;
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder sellingItemGenerator(ItemStackGenerator sellingGenerator) {
            this.sellingGenerator = Objects.requireNonNull(sellingGenerator, "ItemStackGenerator cannot be null!");
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder experienceChance(double experience) {
            this.experience = experience;
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder grantedExperience(VariableAmount amount) {
            this.grantedExperience = Objects.requireNonNull(amount, "Granted experience cannot be null");
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder startingUses(VariableAmount amount) {
            this.baseUses = Objects.requireNonNull(amount, "Variable amount cannot be null!");
            return this;
        }

        @Override
        public TradeOfferGenerator.Builder maxUses(VariableAmount amount) {
            this.maxUses = Objects.requireNonNull(amount, "Variable amount cannot be null!");
            return this;
        }

        @Override
        public TradeOfferGenerator build() {
            Preconditions.checkState((this.firstGenerator != null ? 1 : 0) != 0, (Object)"First item populators cannot be empty! Populate with some BiConsumers!");
            Preconditions.checkState((this.sellingGenerator != null ? 1 : 0) != 0, (Object)"Selling item populators cannot be empty! Populate with some BiConsumers!");
            Preconditions.checkState((this.baseUses != null ? 1 : 0) != 0);
            Preconditions.checkState((this.maxUses != null ? 1 : 0) != 0);
            return new SpongeTradeOfferGenerator(this);
        }

        @Override
        public TradeOfferGenerator.Builder from(TradeOfferGenerator value) {
            this.reset();
            if (value instanceof SpongeTradeOfferGenerator) {
                SpongeTradeOfferGenerator generator = (SpongeTradeOfferGenerator)value;
                this.firstGenerator = generator.firstItemGenerator;
                this.secondGenerator = generator.secondItemGenerator;
                this.sellingGenerator = generator.sellingItemGenerator;
                this.experience = generator.experience;
                this.baseUses = generator.baseUses;
                this.maxUses = generator.maxUses;
                return this;
            }
            throw new IllegalArgumentException("The provided TradeOfferGenerator is incompatible with the current implementation!");
        }

        @Override
        public TradeOfferGenerator.Builder reset() {
            this.firstGenerator = null;
            this.secondGenerator = null;
            this.sellingGenerator = null;
            this.experience = 0.5;
            this.baseUses = null;
            this.maxUses = null;
            this.grantedExperience = null;
            return this;
        }
    }
}

