/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockBreakAckPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.entity.Sign;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.entity.ChangeSignEvent;
import org.spongepowered.api.event.entity.living.AnimateHandEvent;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundMovePlayerPacketAccessor;
import org.spongepowered.common.accessor.server.level.ServerPlayerGameModeAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.network.ServerGamePacketListenerImplBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.data.value.ImmutableSpongeListValue;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.CommandUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin
implements ConnectionHolderBridge,
ServerGamePacketListenerImplBridge {
    @Shadow
    @Final
    public Connection connection;
    @Shadow
    public net.minecraft.server.level.ServerPlayer player;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    private Vec3 awaitingPositionFromClient;
    @Shadow
    private double firstGoodX;
    @Shadow
    private double firstGoodY;
    @Shadow
    private double firstGoodZ;
    @Shadow
    private int receivedMovePacketCount;
    @Shadow
    private int knownMovePacketCount;
    @Shadow
    private int tickCount;
    @Shadow
    private int awaitingTeleportTime;
    private int impl$ignorePackets;

    @Shadow
    protected abstract boolean shadow$isSingleplayerOwner();

    @Shadow
    public abstract void shadow$teleport(double var1, double var3, double var5, float var7, float var8);

    @Shadow
    protected abstract void shadow$filterTextPacket(List<String> var1, Consumer<List<String>> var2);

    @Override
    public Connection bridge$getConnection() {
        return this.connection;
    }

    @Override
    public void bridge$incrementIgnorePackets() {
        ++this.impl$ignorePackets;
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lio/netty/util/concurrent/GenericFutureListener;)V"}, at={@At(value="HEAD")})
    private void impl$onClientboundPacketSend(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> listener, CallbackInfo ci) {
        if (packet instanceof ClientboundPlayerInfoPacket) {
            ((SpongeTabList)((ServerPlayer)this.player).tabList()).updateEntriesOnSend((ClientboundPlayerInfoPacket)packet);
        }
    }

    @Inject(method={"handleCustomCommandSuggestions"}, at={@At(value="NEW", target="com/mojang/brigadier/StringReader", remap=false)}, cancellable=true)
    private void impl$getSuggestionsFromNonBrigCommand(ServerboundCommandSuggestionPacket packet, CallbackInfo ci) {
        String rawCommand = packet.getCommand();
        String[] command = CommandUtil.extractCommandString(rawCommand);
        CommandCause cause = CommandCause.create();
        SpongeCommandManager manager = SpongeCommandManager.get(this.server);
        if (!rawCommand.contains(" ")) {
            SuggestionsBuilder builder = new SuggestionsBuilder(command[0], 0);
            if (command[0].isEmpty()) {
                manager.getAliasesForCause(cause).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            } else {
                manager.getAliasesThatStartWithForCause(cause, command[0]).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), builder.build()));
            ci.cancel();
        } else {
            Optional<CommandMapping> mappingOptional = manager.commandMapping(command[0].toLowerCase(Locale.ROOT)).filter(x -> !(x.registrar() instanceof BrigadierBasedRegistrar));
            if (mappingOptional.isPresent()) {
                CommandMapping mapping = mappingOptional.get();
                if (mapping.registrar().canExecute(cause, mapping)) {
                    SuggestionsBuilder builder = CommandUtil.createSuggestionsForRawCommand(rawCommand, command, cause, mapping);
                    this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), builder.build()));
                } else {
                    this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), (Suggestions)Suggestions.empty().join()));
                }
                ci.cancel();
            }
        }
    }

    @Redirect(method={"handleCustomCommandSuggestions"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;parse(Lcom/mojang/brigadier/StringReader;Ljava/lang/Object;)Lcom/mojang/brigadier/ParseResults;", remap=false))
    private ParseResults<CommandSourceStack> impl$informParserThisIsASuggestionCheck(CommandDispatcher<CommandSourceStack> commandDispatcher, StringReader command, Object source) {
        return SpongeCommandManager.get(this.server).getDispatcher().parse(command, (CommandSourceStack)source, true);
    }

    @ModifyConstant(method={"handleInteract"}, constant={@Constant(doubleValue=36.0)})
    private double impl$getPlatformReach(double thirtySix, ServerboundInteractPacket p_147340_1_) {
        return PlatformHooks.INSTANCE.getGeneralHooks().getEntityReachDistanceSq(this.player, p_147340_1_.getTarget(this.player.getLevel()));
    }

    @Inject(method={"handleMovePlayer"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;awaitingPositionFromClient:Lnet/minecraft/world/phys/Vec3;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;wonGame:Z"), to=@At(value="FIELD", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;tickCount:I", ordinal=1))}, cancellable=true)
    private void impl$callMoveEntityEvent(ServerboundMovePlayerPacket packetIn, CallbackInfo ci) {
        Event event;
        ServerboundMovePlayerPacketAccessor packetInAccessor = (ServerboundMovePlayerPacketAccessor)packetIn;
        if (!packetIn.hasPosition() && !packetIn.hasRotation()) {
            return;
        }
        boolean goodMovementPacket = this.receivedMovePacketCount - this.knownMovePacketCount <= 5;
        boolean fireMoveEvent = goodMovementPacket && packetIn.hasPosition() && ShouldFire.MOVE_ENTITY_EVENT;
        boolean fireRotationEvent = goodMovementPacket && packetIn.hasRotation() && ShouldFire.ROTATE_ENTITY_EVENT;
        ServerPlayer player = (ServerPlayer)this.player;
        Vector3d fromRotation = new Vector3d(this.player.getYRot(), this.player.getXRot(), 0.0f);
        Vector3d fromPosition = player.position();
        Vector3d toPosition = new Vector3d(packetIn.getX(this.player.getX()), packetIn.getY(this.player.getY()), packetIn.getZ(this.player.getZ()));
        Vector3d toRotation = new Vector3d(packetIn.getYRot(this.player.getYRot()), packetIn.getXRot(this.player.getXRot()), 0.0f);
        boolean significantRotation = fromRotation.distanceSquared(toRotation) > (double)0.0225f;
        Vector3d originalToPosition = toPosition;
        boolean cancelMovement = false;
        boolean cancelRotation = false;
        if (fireMoveEvent) {
            event = SpongeEventFactory.createMoveEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerPlayer)this.player, fromPosition, toPosition, toPosition);
            if (SpongeCommon.post(event)) {
                cancelMovement = true;
            } else {
                toPosition = event.destinationPosition();
            }
        }
        if (significantRotation && fireRotationEvent) {
            event = SpongeEventFactory.createRotateEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), (ServerPlayer)this.player, fromRotation, toRotation);
            if (SpongeCommon.post(event)) {
                cancelRotation = true;
                toRotation = fromRotation;
            } else {
                toRotation = event.toRotation();
            }
        }
        if (cancelMovement) {
            if (fromPosition.distanceSquared(toPosition) > 0.0) {
                this.awaitingTeleportTime = this.tickCount;
                this.shadow$teleport(fromPosition.x(), fromPosition.y(), fromPosition.z(), (float)toRotation.x(), (float)toRotation.y());
            } else {
                this.player.absMoveTo(fromPosition.x(), fromPosition.y(), fromPosition.z(), (float)toRotation.x(), (float)toRotation.y());
            }
            ci.cancel();
            return;
        }
        if (!toPosition.equals((Object)originalToPosition)) {
            int i;
            float f2;
            double d10;
            double d6;
            double d9;
            double d5;
            double d8;
            double d4 = packetIn.getX(this.player.getX());
            double d7 = d4 - this.firstGoodX;
            double d11 = d7 * d7 + (d8 = (d5 = packetIn.getY(this.player.getY())) - this.firstGoodY) * d8 + (d9 = (d6 = packetIn.getZ(this.player.getZ())) - this.firstGoodZ) * d9;
            if (d11 - (d10 = this.player.getDeltaMovement().lengthSqr()) > (double)((f2 = this.player.isFallFlying() ? 300.0f : 100.0f) * (float)(i = this.receivedMovePacketCount - this.knownMovePacketCount)) && !this.shadow$isSingleplayerOwner()) {
                this.awaitingPositionFromClient = VecHelper.toVanillaVector3d(toPosition);
                ((EntityAccessor)this.player).invoker$setRot((float)toRotation.x(), (float)toRotation.y());
                this.awaitingTeleportTime = this.tickCount - 21;
            } else {
                packetInAccessor.accessor$hasPos(true);
                packetInAccessor.accessor$x(toPosition.x());
                packetInAccessor.accessor$y(toPosition.y());
                packetInAccessor.accessor$z(toPosition.z());
            }
        }
    }

    @Inject(method={"handleAnimate"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;resetLastActionTime()V")}, cancellable=true)
    private void impl$throwAnimationEvent(ServerboundSwingPacket packetIn, CallbackInfo ci) {
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return;
        }
        SpongeCommonEventFactory.lastAnimationPacketTick = SpongeCommon.server().getTickCount();
        SpongeCommonEventFactory.lastAnimationPlayer = new WeakReference<net.minecraft.server.level.ServerPlayer>(this.player);
        if (!((ServerPlayerGameModeAccessor)this.player.gameMode).accessor$isDestroyingBlock()) {
            if (this.impl$ignorePackets > 0) {
                --this.impl$ignorePackets;
            } else if (ShouldFire.INTERACT_ITEM_EVENT_PRIMARY) {
                Vec3 startPos = this.player.getEyePosition(1.0f);
                Vec3 endPos = startPos.add(this.player.getLookAngle().scale(5.0));
                BlockHitResult result = this.player.getLevel().clip(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.player));
                if (result.getType() == HitResult.Type.MISS) {
                    ItemStack heldItem = this.player.getItemInHand(packetIn.getHand());
                    SpongeCommonEventFactory.callInteractItemEventPrimary((Player)this.player, heldItem, packetIn.getHand());
                }
            }
        }
        if (ShouldFire.ANIMATE_HAND_EVENT) {
            HandType handType = (HandType)packetIn.getHand();
            ItemStack heldItem = this.player.getItemInHand(packetIn.getHand());
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
                frame.addContext(EventContextKeys.USED_HAND, handType);
                AnimateHandEvent event = SpongeEventFactory.createAnimateHandEvent(frame.currentCause(), handType, (Humanoid)this.player);
                if (SpongeCommon.post(event)) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"handlePlayerAction"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;drop(Z)Z")})
    public void impl$dropItem(ServerboundPlayerActionPacket p_147345_1_, CallbackInfo ci) {
        ++this.impl$ignorePackets;
    }

    @Redirect(method={"handlePlayerAction"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;handleBlockBreakAction(Lnet/minecraft/core/BlockPos;Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket$Action;Lnet/minecraft/core/Direction;I)V"))
    public void impl$callInteractBlockPrimaryEvent(ServerPlayerGameMode playerInteractionManager, BlockPos p_225416_1_, ServerboundPlayerActionPacket.Action p_225416_2_, Direction p_225416_3_, int p_225416_4_) {
        ServerLevel level = ((ServerPlayerGameModeAccessor)playerInteractionManager).accessor$level();
        BlockSnapshot snapshot = ((ServerWorld)level).createSnapshot(VecHelper.toVector3i(p_225416_1_));
        InteractBlockEvent.Primary event = SpongeCommonEventFactory.callInteractBlockEventPrimary(p_225416_2_, (Player)this.player, this.player.getItemInHand(InteractionHand.MAIN_HAND), snapshot, InteractionHand.MAIN_HAND, p_225416_3_);
        if (event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled()) {
            this.player.connection.send((Packet)new ClientboundBlockBreakAckPacket(p_225416_1_, level.getBlockState(p_225416_1_), p_225416_2_, false, "block action restricted"));
            ++this.impl$ignorePackets;
        } else {
            if (p_225416_2_ == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK && !Objects.equals(((ServerPlayerGameModeAccessor)playerInteractionManager).accessor$destroyPos(), p_225416_1_)) {
                return;
            }
            playerInteractionManager.handleBlockBreakAction(p_225416_1_, p_225416_2_, p_225416_3_, p_225416_4_);
            if (p_225416_2_ == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
                ++this.impl$ignorePackets;
            }
        }
    }

    @Redirect(method={"handleClientCommand"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;respawn(Lnet/minecraft/server/level/ServerPlayer;Z)Lnet/minecraft/server/level/ServerPlayer;"))
    private net.minecraft.server.level.ServerPlayer impl$usePlayerDimensionForRespawn(PlayerList playerList, net.minecraft.server.level.ServerPlayer player, boolean keepAllPlayerData) {
        ResourceKey respawnDimension = player.getRespawnDimension();
        @Nullable ServerLevel destinationWorld = this.server.getLevel(respawnDimension);
        ServerLevel overworld = this.server.getLevel(Level.OVERWORLD);
        if (overworld == null) {
            throw new IllegalStateException("Somehow the Overworld is not retrievable while trying to respawn player " + player.getGameProfile().getName());
        }
        ServerLevel destination = destinationWorld == null ? overworld : destinationWorld;
        RespawnPlayerEvent.SelectWorld event = SpongeEventFactory.createRespawnPlayerEventSelectWorld(PhaseTracker.getCauseStackManager().currentCause(), (ServerWorld)destination, (ServerWorld)player.getLevel(), (ServerWorld)overworld, (ServerPlayer)player);
        SpongeCommon.post(event);
        ((PlayerListBridge)this.server.getPlayerList()).bridge$setOriginalDestinationDimension((ResourceKey<Level>)((ServerLevel)event.originalDestinationWorld()).dimension());
        ((PlayerListBridge)this.server.getPlayerList()).bridge$setNewDestinationDimension((ResourceKey<Level>)((ServerLevel)event.destinationWorld()).dimension());
        return playerList.respawn(player, keepAllPlayerData);
    }

    @Redirect(method={"onDisconnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/ChatType;Ljava/util/UUID;)V"))
    public void impl$handlePlayerDisconnect(PlayerList playerList, net.minecraft.network.chat.Component component, ChatType chatType, UUID uuid) {
        if (this.player.connection == null) {
            return;
        }
        ServerPlayer spongePlayer = (ServerPlayer)this.player;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.player);
            Component message = SpongeAdventure.asAdventure(component);
            Audience audience = Sponge.server().broadcastAudience();
            ServerSideConnectionEvent.Disconnect event = SpongeEventFactory.createServerSideConnectionEventDisconnect(PhaseTracker.getCauseStackManager().currentCause(), audience, Optional.of(audience), message, message, spongePlayer.connection(), spongePlayer);
            SpongeCommon.post(event);
            event.audience().ifPresent(a -> a.sendMessage((Identified)spongePlayer, event.message()));
        }
        ((ServerPlayerBridge)this.player).bridge$getWorldBorderListener().onPlayerDisconnect();
    }

    @Redirect(method={"handleSignUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;filterTextPacket(Ljava/util/List;Ljava/util/function/Consumer;)V"))
    private void impl$switchToSignPhaseState(ServerGamePacketListenerImpl serverPlayNetHandler, List<String> p_244537_1_, Consumer<List<String>> p_244537_2_) {
        try (BasicPacketContext context = (BasicPacketContext)((BasicPacketContext)PacketPhase.General.UPDATE_SIGN.createPhaseContext(PhaseTracker.getInstance()).packetPlayer(this.player)).buildAndSwitch();){
            this.shadow$filterTextPacket(p_244537_1_, p_244537_2_);
        }
    }

    @Redirect(method={"updateSignText"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/List;size()I"))
    private int impl$callChangeSignEvent(List<TextFilter.FilteredText> list, ServerboundSignUpdatePacket p_244542_1_, List<String> p_244542_2_) {
        SignBlockEntity blockEntity = (SignBlockEntity)this.player.level.getBlockEntity(p_244542_1_.getPos());
        ListValue.Mutable<Component> originalLinesValue = ((Sign)blockEntity).getValue(Keys.SIGN_LINES).orElseGet(() -> new ImmutableSpongeListValue(Keys.SIGN_LINES, ImmutableList.of()));
        ArrayList<TextComponent> newLines = new ArrayList<TextComponent>();
        for (TextFilter.FilteredText line : list) {
            newLines.add(Component.text((String)SharedConstants.filterText((String)line.getFiltered())));
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.player);
            ListValue.Mutable<Component> newLinesValue = ListValue.mutableOf(Keys.SIGN_LINES, newLines);
            ChangeSignEvent event = SpongeEventFactory.createChangeSignEvent(PhaseTracker.getCauseStackManager().currentCause(), (ListValue.Immutable<Component>)originalLinesValue.asImmutable(), newLinesValue, (Sign)blockEntity);
            ListValue.Mutable<Component> toApply = SpongeCommon.post(event) ? originalLinesValue : newLinesValue;
            ((Sign)blockEntity).offer(toApply);
        }
        return 0;
    }
}

