/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.players;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.players.GameProfileCache;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.players.GameProfileCache_GameProfileInfoAccessor;
import org.spongepowered.common.bridge.server.players.GameProfileCacheBridge;
import org.spongepowered.common.bridge.server.players.GameProfileCache_GameProfileInfoBridge;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={GameProfileCache.class})
public abstract class GameProfileCacheMixin
implements GameProfileCacheBridge {
    @Shadow
    @Final
    private Map<UUID, GameProfileCache_GameProfileInfoAccessor> profilesByUUID;
    @Shadow
    @Final
    private Map<String, GameProfileCache_GameProfileInfoAccessor> profilesByName;
    private boolean impl$canSave = false;

    @Shadow
    public void shadow$add(com.mojang.authlib.GameProfile profile) {
    }

    @Override
    public Optional<GameProfileCache_GameProfileInfoBridge> bridge$getEntry(UUID uniqueId) {
        GameProfileCache_GameProfileInfoAccessor accessor = this.profilesByUUID.get(Objects.requireNonNull(uniqueId, "uniqueId"));
        if (accessor == null) {
            return Optional.empty();
        }
        if (accessor.invoker$getExpirationDate().getTime() < System.currentTimeMillis()) {
            this.profilesByUUID.remove(uniqueId, accessor);
            this.profilesByName.remove(accessor.invoker$getProfile().getName(), accessor);
            return Optional.empty();
        }
        return Optional.of((GameProfileCache_GameProfileInfoBridge)((Object)accessor));
    }

    @Override
    public Optional<GameProfileCache_GameProfileInfoBridge> bridge$getEntry(String name) {
        String lowerName = Objects.requireNonNull(name, "name").toLowerCase(Locale.ROOT);
        GameProfileCache_GameProfileInfoAccessor accessor = this.profilesByName.get(lowerName);
        if (accessor == null) {
            return Optional.empty();
        }
        if (accessor.invoker$getExpirationDate().getTime() < System.currentTimeMillis()) {
            this.profilesByUUID.remove(accessor.invoker$getProfile().getId(), accessor);
            this.profilesByName.remove(lowerName, accessor);
            return Optional.empty();
        }
        return Optional.of((GameProfileCache_GameProfileInfoBridge)((Object)accessor));
    }

    @Override
    public void bridge$add(com.mojang.authlib.GameProfile profile, boolean full, boolean signed) {
        com.mojang.authlib.GameProfile current;
        GameProfileCache_GameProfileInfoAccessor accessor = this.profilesByUUID.get(Objects.requireNonNull(profile, "profile").getId());
        com.mojang.authlib.GameProfile gameProfile = current = accessor == null ? null : accessor.invoker$getProfile();
        if (current != null && Objects.equals(current.getId(), profile.getId()) && Objects.equals(current.getName(), profile.getName()) && !full) {
            return;
        }
        this.shadow$add(profile);
        accessor = this.profilesByUUID.get(profile.getId());
        if (accessor == null || accessor.invoker$getProfile() != profile) {
            return;
        }
        GameProfileCache_GameProfileInfoBridge bridge = (GameProfileCache_GameProfileInfoBridge)((Object)accessor);
        bridge.bridge$setSigned(signed);
        bridge.bridge$setIsFull(full);
    }

    @Override
    public void bridge$add(GameProfile profile, boolean full, boolean signed) {
        GameProfileCache_GameProfileInfoAccessor accessor = this.profilesByUUID.get(Objects.requireNonNull(profile, "profile").uniqueId());
        com.mojang.authlib.GameProfile current = accessor == null ? null : accessor.invoker$getProfile();
        com.mojang.authlib.GameProfile mcProfile = SpongeGameProfile.toMcProfile(profile);
        if (current != null && Objects.equals(current.getId(), mcProfile.getId()) && Objects.equals(current.getName(), mcProfile.getName()) && !full) {
            return;
        }
        this.shadow$add(mcProfile);
        accessor = this.profilesByUUID.get(profile.uniqueId());
        if (accessor == null || accessor.invoker$getProfile() != mcProfile) {
            return;
        }
        ((GameProfileCache_GameProfileInfoBridge)((Object)accessor)).bridge$set(profile, full, signed);
    }

    @Override
    public void bridge$setCanSave(boolean flag) {
        this.impl$canSave = flag;
    }

    @Inject(method={"add"}, at={@At(value="RETURN")})
    private void impl$updateCacheUsername(com.mojang.authlib.GameProfile profile, CallbackInfo ci) {
        if (profile.getName() != null) {
            ((SpongeServer)Sponge.server()).getUsernameCache().setUsername(profile.getId(), profile.getName());
        }
    }

    @Redirect(method={"lookupGameProfile"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/GameProfileRepository;findProfilesByNames([Ljava/lang/String;Lcom/mojang/authlib/Agent;Lcom/mojang/authlib/ProfileLookupCallback;)V", remap=false))
    private static void impl$lookUpViaSponge(GameProfileRepository repository, String[] names, Agent agent, ProfileLookupCallback callback) {
        GameProfileManager profileManager = Sponge.server().gameProfileManager();
        profileManager.basicProfile(names[0]).whenComplete((profile, ex) -> {
            if (ex != null) {
                callback.onProfileLookupFailed(new com.mojang.authlib.GameProfile(null, names[0]), ex instanceof Exception ? (Exception)ex : new RuntimeException((Throwable)ex));
            } else {
                callback.onProfileLookupSucceeded(SpongeGameProfile.toMcProfile(profile));
            }
        });
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$ignoreSavingIfCancelled(CallbackInfo ci) {
        if (!this.impl$canSave) {
            ci.cancel();
        }
    }
}

