/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={LightningBolt.class})
public abstract class LightningBoltMixin
extends EntityMixin {
    private final List<Entity> impl$struckEntities = Lists.newArrayList();
    private boolean impl$effect = false;

    @Redirect(method={"spawnFire"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    private boolean impl$throwEventForChangingBlocks(Level world, BlockPos pos, BlockState blockState) {
        return this.impl$strikeBlockAndAddSnapshot(world, pos, blockState);
    }

    @Redirect(method={"spawnFire(I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    private boolean impl$throwEventForChangingBlockDuringUpdate(Level world, BlockPos pos, BlockState blockState) {
        return this.impl$strikeBlockAndAddSnapshot(world, pos, blockState);
    }

    private boolean impl$strikeBlockAndAddSnapshot(Level world, BlockPos pos, BlockState blockState) {
        if (!this.impl$effect && ((World)world).contains(pos.getX(), pos.getY(), pos.getZ())) {
            Vector3i pos3i = VecHelper.toVector3i(pos);
            Transaction<SpongeBlockSnapshot> transaction = new Transaction<SpongeBlockSnapshot>(SpongeBlockSnapshot.BuilderImpl.pooled().blockState(world.getBlockState(pos)).world((ServerLevel)world).position(pos3i).build(), SpongeBlockSnapshot.BuilderImpl.pooled().blockState(blockState).world((ServerLevel)world).position(pos3i).build());
            return true;
        }
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;thunderHit(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LightningBolt;)V"))
    private void impl$AddEntityToListForEvent(net.minecraft.world.entity.Entity mcEntity, ServerLevel level, LightningBolt lightningBolt) {
        Entity entity;
        if (!this.impl$effect && !this.impl$struckEntities.contains(entity = (Entity)mcEntity)) {
            this.impl$struckEntities.add(entity);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LightningBolt;remove()V")})
    private void impl$ThrowEventAndProcess(CallbackInfo ci) {
        if (this.shadow$isRemoved() || this.level.isClientSide) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            LightningEvent.Strike strike = SpongeEventFactory.createLightningEventStrike(frame.currentCause(), this.impl$struckEntities);
            Sponge.eventManager().post(strike);
            if (!strike.isCancelled()) {
                for (Entity e : strike.entities()) {
                    ((net.minecraft.world.entity.Entity)e).thunderHit((ServerLevel)this.level, (LightningBolt)this);
                }
                SpongeCommon.post(SpongeEventFactory.createLightningEventPost(frame.currentCause()));
            }
        }
    }
}

