/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.SleepingEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.world.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.world.entity.LivingEntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformLivingEntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.damage.SpongeDamageSources;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.common.util.DamageEventUtil;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityBridge,
PlatformLivingEntityBridge {
    @Shadow
    public int hurtTime;
    @Shadow
    public int hurtDuration;
    @Shadow
    public float hurtDir;
    @Shadow
    public float animationSpeed;
    @Shadow
    protected int noActionTime;
    @Shadow
    protected int lastHurtByPlayerTime;
    @Shadow
    protected int useItemRemaining;
    @Shadow
    protected float lastHurt;
    @Shadow
    @Nullable
    protected Player lastHurtByPlayer;
    @Shadow
    private DamageSource lastDamageSource;
    @Shadow
    private long lastDamageStamp;
    @Shadow
    protected boolean dead;
    @Shadow
    public int deathTime;
    @Shadow
    protected int deathScore;
    @Shadow
    protected ItemStack useItem;
    @Nullable
    private ItemStack impl$activeItemStackCopy;
    @Nullable
    private Vector3d impl$preTeleportPosition;
    private int impl$deathEventsPosted;

    @Shadow
    public abstract AttributeInstance shadow$getAttribute(Attribute var1);

    @Shadow
    public abstract void shadow$setHealth(float var1);

    @Shadow
    public abstract void shadow$knockback(double var1, double var3, double var5);

    @Shadow
    public abstract void shadow$setLastHurtByMob(LivingEntity var1);

    @Shadow
    public abstract void shadow$setAbsorptionAmount(float var1);

    @Shadow
    public abstract void shadow$setItemInHand(InteractionHand var1, @Nullable ItemStack var2);

    @Shadow
    public abstract void shadow$stopUsingItem();

    @Shadow
    public abstract int shadow$getUseItemRemainingTicks();

    @Shadow
    public abstract float shadow$getAbsorptionAmount();

    @Shadow
    public abstract float shadow$getHealth();

    @Shadow
    public abstract boolean shadow$hasEffect(MobEffect var1);

    @Shadow
    protected abstract boolean shadow$isDamageSourceBlocked(DamageSource var1);

    @Shadow
    public abstract ItemStack shadow$getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract ItemStack shadow$getMainHandItem();

    @Shadow
    public abstract CombatTracker shadow$getCombatTracker();

    @Shadow
    public void shadow$kill() {
    }

    @Shadow
    public abstract InteractionHand shadow$getUsedItemHand();

    @Shadow
    protected abstract void shadow$markHurt();

    @Shadow
    protected abstract void shadow$hurtCurrentlyUsedShield(float var1);

    @Shadow
    protected abstract void shadow$playHurtSound(DamageSource var1);

    @Shadow
    protected abstract void shadow$blockUsingShield(LivingEntity var1);

    @Shadow
    protected abstract float shadow$getSoundVolume();

    @Shadow
    protected abstract float shadow$getVoicePitch();

    @Shadow
    protected abstract SoundEvent shadow$getDeathSound();

    @Shadow
    public abstract boolean shadow$isSleeping();

    @Shadow
    public abstract Optional<BlockPos> shadow$getSleepingPos();

    @Shadow
    private boolean shadow$checkTotemDeathProtection(DamageSource p_190628_1_) {
        return false;
    }

    @Shadow
    public abstract void shadow$die(DamageSource var1);

    @Shadow
    protected abstract void shadow$spawnItemParticles(ItemStack var1, int var2);

    @Shadow
    public abstract void shadow$stopSleeping();

    @Shadow
    protected abstract void shadow$actuallyHurt(DamageSource var1, float var2);

    @Shadow
    public abstract boolean shadow$onClimbable();

    @Shadow
    public abstract void shadow$setSprinting(boolean var1);

    @Shadow
    public abstract void shadow$setLastHurtMob(net.minecraft.world.entity.Entity var1);

    @Shadow
    protected abstract void shadow$hurtArmor(DamageSource var1, float var2);

    @Shadow
    public abstract ItemStack shadow$getItemInHand(InteractionHand var1);

    @Shadow
    protected abstract void shadow$dropEquipment();

    @Shadow
    protected abstract void shadow$dropAllDeathLoot(DamageSource var1);

    @Shadow
    @Nullable
    public abstract LivingEntity shadow$getKillCredit();

    @Shadow
    protected abstract void shadow$createWitherRose(@Nullable LivingEntity var1);

    @Shadow
    public abstract Collection<MobEffectInstance> shadow$getActiveEffects();

    @Shadow
    public abstract float shadow$getMaxHealth();

    @Shadow
    public abstract AttributeMap shadow$getAttributes();

    @Shadow
    public abstract void shadow$clearSleepingPos();

    @Override
    public boolean bridge$damageEntity(DamageSource damageSource, float damage) {
        if (this.shadow$isInvulnerableTo(damageSource)) {
            return false;
        }
        boolean isHuman = (LivingEntity)this instanceof Player;
        float originalDamage = damage = this.bridge$applyModDamage((LivingEntity)this, damageSource, damage);
        if (damage <= 0.0f) {
            return false;
        }
        ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
        Optional<DamageFunction> hardHatFunction = DamageEventUtil.createHardHatModifier((LivingEntity)this, damageSource);
        Optional<DamageFunction> armorFunction = DamageEventUtil.createArmorModifiers((LivingEntity)this, damageSource);
        Optional<DamageFunction> resistanceFunction = DamageEventUtil.createResistanceModifier((LivingEntity)this, damageSource);
        Optional<List<DamageFunction>> armorEnchantments = DamageEventUtil.createEnchantmentModifiers((LivingEntity)this, damageSource);
        Optional<DamageFunction> absorptionFunction = DamageEventUtil.createAbsorptionModifier((LivingEntity)this);
        Optional<DamageFunction> shieldFunction = DamageEventUtil.createShieldFunction((LivingEntity)this, damageSource, damage);
        hardHatFunction.ifPresent(originalFunctions::add);
        shieldFunction.ifPresent(originalFunctions::add);
        armorFunction.ifPresent(originalFunctions::add);
        resistanceFunction.ifPresent(originalFunctions::add);
        armorEnchantments.ifPresent(originalFunctions::addAll);
        absorptionFunction.ifPresent(originalFunctions::add);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            float f2;
            DamageEventUtil.generateCauseFor(damageSource, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.currentCause(), (Entity)((Object)this), originalFunctions, originalDamage);
            if (damageSource != SpongeDamageSources.IGNORED) {
                SpongeCommon.post(event);
            }
            if (event.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            damage = (float)event.finalDamage();
            damage = this.bridge$applyModDamageBeforeFunctions((LivingEntity)this, damageSource, damage);
            ItemStack helmet = this.shadow$getItemBySlot(EquipmentSlot.HEAD);
            if (damageSource instanceof FallingBlockDamageSource || damageSource == DamageSource.ANVIL || damageSource == DamageSource.FALLING_BLOCK && !helmet.isEmpty()) {
                helmet.hurtAndBreak((int)(event.baseDamage() * 4.0 + (double)this.random.nextFloat() * event.baseDamage() * 2.0), (LivingEntity)this, entity -> entity.broadcastBreakEvent(EquipmentSlot.HEAD));
            }
            boolean hurtStack = false;
            if (shieldFunction.isPresent()) {
                net.minecraft.world.entity.Entity entity2;
                this.shadow$hurtCurrentlyUsedShield((float)event.baseDamage());
                hurtStack = true;
                if (!damageSource.isProjectile() && (entity2 = damageSource.getDirectEntity()) instanceof LivingEntity) {
                    this.shadow$blockUsingShield((LivingEntity)entity2);
                }
            }
            if (!damageSource.isBypassArmor() && armorFunction.isPresent()) {
                this.shadow$hurtArmor(damageSource, (float)event.baseDamage());
                hurtStack = true;
            }
            if (hurtStack && isHuman) {
                PhaseTracker.SERVER.getPhaseContext().getTransactor().logPlayerInventoryChange((Player)this, PlayerInventoryTransaction.EventCreator.STANDARD);
                ((Player)this).inventoryMenu.broadcastChanges();
            }
            if (resistanceFunction.isPresent() && (f2 = (float)event.damage(resistanceFunction.get().modifier()) - damage) > 0.0f && f2 < 3.4028235E37f) {
                if ((LivingEntity)this instanceof net.minecraft.server.level.ServerPlayer) {
                    ((net.minecraft.server.level.ServerPlayer)((LivingEntity)this)).awardStat(Stats.DAMAGE_RESISTED, Math.round(f2 * 10.0f));
                } else if (damageSource.getEntity() instanceof net.minecraft.server.level.ServerPlayer) {
                    ((net.minecraft.server.level.ServerPlayer)damageSource.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round(f2 * 10.0f));
                }
            }
            double absorptionModifier = absorptionFunction.map(function -> event.damage(function.modifier())).orElse(0.0);
            if (absorptionFunction.isPresent()) {
                absorptionModifier = event.damage(absorptionFunction.get().modifier());
            }
            float f = (float)event.finalDamage() - (float)absorptionModifier;
            this.shadow$setAbsorptionAmount(Math.max(this.shadow$getAbsorptionAmount() + (float)absorptionModifier, 0.0f));
            if (f > 0.0f && f < 3.4028235E37f && damageSource.getEntity() instanceof net.minecraft.server.level.ServerPlayer) {
                ((net.minecraft.server.level.ServerPlayer)damageSource.getEntity()).awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round(f * 10.0f));
            }
            if (damage != 0.0f) {
                if (isHuman) {
                    ((Player)this).causeFoodExhaustion(damageSource.getFoodExhaustion());
                }
                float f22 = this.shadow$getHealth();
                this.shadow$setHealth(f22 - damage);
                this.shadow$getCombatTracker().recordDamage(damageSource, f22, damage);
                if (isHuman) {
                    boolean bl = true;
                    return bl;
                }
                this.shadow$setAbsorptionAmount(this.shadow$getAbsorptionAmount() - damage);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Inject(method={"setHealth"}, at={@At(value="HEAD")})
    private void impl$resetDeathEventCounter(float health, CallbackInfo info) {
        if (this.shadow$getHealth() <= 0.0f && health > 0.0f) {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Redirect(method={"dropExperience()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getExperienceReward(Lnet/minecraft/world/entity/player/Player;)I"))
    protected int impl$exposeGetExperienceForDeath(LivingEntity entity, Player attackingPlayer) {
        return this.bridge$getExperiencePointsOnDeath(entity, attackingPlayer);
    }

    @Overwrite
    protected void actuallyHurt(DamageSource damageSource, float damage) {
        this.bridge$damageEntity(damageSource, damage);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwDestructEntityDeath(DamageSource cause, CallbackInfo ci) {
        boolean throwEvent;
        boolean bl = throwEvent = !((LevelBridge)this.level).bridge$isFake() && Sponge.isServerAvailable() && Sponge.server().onMainThread();
        if (!this.dead) {
            if (throwEvent && this.impl$deathEventsPosted <= 3) {
                ++this.impl$deathEventsPosted;
                if (SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)this, cause).isCancelled()) {
                    ci.cancel();
                }
            }
        } else {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;broadcastEntityEvent(Lnet/minecraft/world/entity/Entity;B)V")}, cancellable=true)
    private void impl$doNotSendStateForHumans(DamageSource cause, CallbackInfo ci) {
        if ((LivingEntity)this instanceof HumanEntity) {
            ci.cancel();
        }
    }

    @Redirect(method={"dropAllDeathLoot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropEquipment()V"))
    private void tracker$dropInventory(LivingEntity thisEntity) {
        if (thisEntity instanceof PlayerBridge && ((PlayerBridge)thisEntity).bridge$keepInventory()) {
            return;
        }
        this.shadow$dropEquipment();
    }

    @Overwrite
    public boolean hurt(DamageSource source, float amount) {
        boolean flag2;
        boolean flag;
        this.lastDamageSource = source;
        if (source == null) {
            new PrettyPrinter(60).centre().add("Null DamageSource").hr().addWrapped("Sponge has found a null damage source! This should NEVER happen as the DamageSource is used for all sorts of calculations. Usually this can be considered developer error. Please report the following stacktrace to the most appropriate mod/plugin available.", new Object[0]).add().add(new IllegalArgumentException("Null DamageSource")).log(SpongeCommon.logger(), org.apache.logging.log4j.Level.WARN);
            return false;
        }
        if (!this.bridge$onLivingAttack((LivingEntity)this, source, amount)) {
            return false;
        }
        if (this.shadow$isInvulnerableTo(source)) {
            return false;
        }
        if (this.level.isClientSide) {
            return false;
        }
        if (this.shadow$getHealth() <= 0.0f && source != SpongeDamageSources.IGNORED) {
            return false;
        }
        if (source.isFire() && this.shadow$hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.shadow$isSleeping() && !this.level.isClientSide) {
            this.shadow$stopSleeping();
        }
        this.noActionTime = 0;
        float f = amount;
        float f1 = 0.0f;
        boolean bl = flag = amount > 0.0f && this.shadow$isDamageSourceBlocked(source);
        if (flag) {
            f1 = amount;
        }
        this.animationSpeed = 1.5f;
        boolean flag1 = true;
        if ((float)this.invulnerableTime > 10.0f) {
            if (amount <= this.lastHurt) {
                return false;
            }
            if (((EntityTypeBridge)this.shadow$getType()).bridge$overridesDamageEntity()) {
                this.shadow$actuallyHurt(source, amount - this.lastHurt);
            } else if (!this.bridge$damageEntity(source, amount - this.lastHurt)) {
                return false;
            }
            this.lastHurt = amount;
            flag1 = false;
        } else {
            if (((EntityTypeBridge)this.shadow$getType()).bridge$overridesDamageEntity()) {
                this.shadow$actuallyHurt(source, amount);
            } else if (!this.bridge$damageEntity(source, amount)) {
                return false;
            }
            this.lastHurt = amount;
            this.invulnerableTime = 20;
            this.hurtTime = this.hurtDuration = 10;
        }
        this.hurtDir = 0.0f;
        net.minecraft.world.entity.Entity entity = source.getEntity();
        if (entity != null) {
            TamableAnimal wolfentity;
            if (entity instanceof LivingEntity) {
                this.shadow$setLastHurtByMob((LivingEntity)entity);
            }
            if (entity instanceof Player) {
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = (Player)entity;
            } else if (entity instanceof TamableAnimal && (wolfentity = (TamableAnimal)entity).isTame()) {
                this.lastHurtByPlayerTime = 100;
                LivingEntity livingentity = wolfentity.getOwner();
                this.lastHurtByPlayer = livingentity != null && livingentity.getType() == EntityType.PLAYER ? (Player)livingentity : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.level.broadcastEntityEvent((net.minecraft.world.entity.Entity)((LivingEntity)this), (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).isThorns()) {
                this.level.broadcastEntityEvent((net.minecraft.world.entity.Entity)((LivingEntity)this), (byte)33);
            } else {
                byte b0 = source == DamageSource.DROWN ? (byte)36 : (source.isFire() ? (byte)37 : (source == DamageSource.SWEET_BERRY_BUSH ? (byte)44 : 2));
                this.level.broadcastEntityEvent((net.minecraft.world.entity.Entity)((LivingEntity)this), b0);
            }
            if (source != DamageSource.DROWN && !flag) {
                this.shadow$markHurt();
            }
            if (entity != null) {
                double d1 = entity.getX() - this.shadow$getX();
                double d0 = entity.getZ() - this.shadow$getZ();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.hurtDir = (float)(Mth.atan2((double)d0, (double)d1) * 57.2957763671875 - (double)this.shadow$getYRot());
                this.shadow$knockback(0.4, d1, d0);
            } else {
                this.hurtDir = (float)(Math.random() * 2.0 * 180.0);
            }
        }
        if (this.shadow$getHealth() <= 0.0f) {
            if (!this.shadow$checkTotemDeathProtection(source)) {
                SoundEvent soundevent = this.shadow$getDeathSound();
                if (!this.bridge$isVanished() && flag1 && soundevent != null) {
                    this.shadow$playSound(soundevent, this.shadow$getSoundVolume(), this.shadow$getVoicePitch());
                }
                this.shadow$die(source);
            }
        } else if (flag1 && !this.bridge$isVanished()) {
            this.shadow$playHurtSound(source);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.lastDamageSource = source;
            this.lastDamageStamp = this.level.getGameTime();
        }
        if ((LivingEntity)this instanceof net.minecraft.server.level.ServerPlayer) {
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((net.minecraft.server.level.ServerPlayer)this, source, f, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                ((net.minecraft.server.level.ServerPlayer)this).awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(f1 * 10.0f));
            }
        }
        if (entity instanceof net.minecraft.server.level.ServerPlayer) {
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((net.minecraft.server.level.ServerPlayer)entity, (net.minecraft.world.entity.Entity)this, source, f, amount, flag);
        }
        return flag2;
    }

    @Redirect(method={"triggerItemUseEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;spawnItemParticles(Lnet/minecraft/world/item/ItemStack;I)V"))
    private void impl$hideItemParticlesIfVanished(LivingEntity livingEntity, ItemStack stack, int count) {
        if (!this.bridge$isVanished()) {
            this.shadow$spawnItemParticles(stack, count);
        }
    }

    @Inject(method={"randomTeleport"}, at={@At(value="HEAD")})
    private void impl$snapshotPositionBeforeVanillaTeleportLogic(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        this.impl$preTeleportPosition = new Vector3d(this.shadow$getX(), this.shadow$getY(), this.shadow$getZ());
    }

    @Inject(method={"randomTeleport"}, at={@At(value="RETURN", ordinal=0, shift=At.Shift.BY, by=2)}, cancellable=true)
    private void impl$callMoveEntityEventForTeleport(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        if (!ShouldFire.MOVE_ENTITY_EVENT) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            MoveEntityEvent event;
            frame.pushCause(this);
            if (!frame.currentContext().containsKey(EventContextKeys.MOVEMENT_TYPE)) {
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENTITY_TELEPORT);
            }
            if (SpongeCommon.post(event = SpongeEventFactory.createMoveEntityEvent(frame.currentCause(), (Entity)((Object)this), this.impl$preTeleportPosition, new Vector3d(this.shadow$getX(), this.shadow$getY(), this.shadow$getZ()), new Vector3d(x, y, z)))) {
                this.shadow$teleportTo(this.impl$preTeleportPosition.x(), this.impl$preTeleportPosition.y(), this.impl$preTeleportPosition.z());
                cir.setReturnValue((Object)false);
                return;
            }
            this.shadow$teleportTo(event.destinationPosition().x(), event.destinationPosition().y(), event.destinationPosition().z());
        }
    }

    @Inject(method={"startUsingItem"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;useItem:Lnet/minecraft/world/item/ItemStack;")})
    private void impl$onSetActiveItemStack(InteractionHand hand, CallbackInfo ci, ItemStack stack) {
        UseItemStackEvent.Start event;
        if (this.level.isClientSide) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)hand;
            this.impl$addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventStart(PhaseTracker.getCauseStackManager().currentCause(), stack.getUseDuration(), stack.getUseDuration(), snapshot);
        }
        if (SpongeCommon.post(event)) {
            ci.cancel();
        } else {
            this.useItemRemaining = event.remainingDuration();
        }
    }

    @Redirect(method={"startUsingItem"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;useItemRemaining:I"))
    private void impl$getItemDuration(LivingEntity this$0, int count) {
        if (this.level.isClientSide) {
            this.useItemRemaining = count;
        }
    }

    private void impl$addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot, HandType hand) {
        frame.addContext(EventContextKeys.USED_HAND, hand);
        this.impl$addSelfToFrame(frame, snapshot);
    }

    private void impl$addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot) {
        frame.pushCause(this);
        frame.addContext(EventContextKeys.USED_ITEM, snapshot);
        if (this instanceof ServerPlayer) {
            frame.addContext(EventContextKeys.CREATOR, ((ServerPlayer)((Object)this)).uniqueId());
            frame.addContext(EventContextKeys.NOTIFIER, ((ServerPlayer)((Object)this)).uniqueId());
        }
    }

    @Redirect(method={"updateUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getUseItemRemainingTicks()I", ordinal=0))
    private int impl$onGetRemainingItemDuration(LivingEntity self) {
        UseItemStackEvent.Tick event;
        if (this.level.isClientSide) {
            return self.getUseItemRemainingTicks();
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.useItem);
            HandType handType = (HandType)this.shadow$getUsedItemHand();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventTick(PhaseTracker.getCauseStackManager().currentCause(), this.useItemRemaining, this.useItemRemaining, snapshot);
            SpongeCommon.post(event);
        }
        this.useItemRemaining = Math.max(event.remainingDuration(), 1);
        if (event.isCancelled()) {
            return 26;
        }
        return this.shadow$getUseItemRemainingTicks();
    }

    @Inject(method={"completeUsingItem"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V")})
    private void impl$onUpdateItemUse(CallbackInfo ci) {
        UseItemStackEvent.Finish event;
        if (this.level.isClientSide) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.useItem);
            HandType handType = (HandType)this.shadow$getUsedItemHand();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventFinish(PhaseTracker.getCauseStackManager().currentCause(), this.useItemRemaining, this.useItemRemaining, snapshot);
        }
        SpongeCommon.post(event);
        if (event.remainingDuration() > 0) {
            this.useItemRemaining = event.remainingDuration();
            ci.cancel();
        } else if (event.isCancelled()) {
            this.shadow$stopUsingItem();
            ci.cancel();
        } else {
            this.impl$activeItemStackCopy = this.useItem.copy();
        }
    }

    @Redirect(method={"completeUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setItemInHand(Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V"))
    private void impl$onSetHeldItem(LivingEntity self, InteractionHand hand, ItemStack stack) {
        UseItemStackEvent.Replace event;
        if (this.level.isClientSide) {
            self.setItemInHand(hand, stack);
            return;
        }
        ItemStackSnapshot activeItemStackSnapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy == null ? ItemStack.EMPTY : this.impl$activeItemStackCopy);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack == null ? ItemStack.EMPTY : stack);
            HandType handType = (HandType)hand;
            this.impl$addSelfToFrame(frame, activeItemStackSnapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventReplace(PhaseTracker.getCauseStackManager().currentCause(), this.useItemRemaining, this.useItemRemaining, activeItemStackSnapshot, new Transaction<ItemStackSnapshot>(ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy), snapshot));
        }
        if (SpongeCommon.post(event)) {
            this.shadow$setItemInHand(hand, this.impl$activeItemStackCopy.copy());
            return;
        }
        if (!event.itemStackResult().isValid()) {
            this.shadow$setItemInHand(hand, this.impl$activeItemStackCopy.copy());
            return;
        }
        this.shadow$setItemInHand(hand, ItemStackUtil.fromSnapshotToNative(event.itemStackResult().finalReplacement()));
    }

    @Redirect(method={"releaseUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;releaseUsing(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"))
    private void impl$onStopPlayerUsing(ItemStack stack, Level world, LivingEntity self, int duration) {
        if (this.level.isClientSide) {
            stack.releaseUsing(world, self, duration);
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)this.shadow$getUsedItemHand();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            if (!SpongeCommon.post(SpongeEventFactory.createUseItemStackEventStop(PhaseTracker.getCauseStackManager().currentCause(), duration, duration, snapshot))) {
                stack.releaseUsing(world, self, duration);
                if (self instanceof net.minecraft.server.level.ServerPlayer) {
                    PhaseTracker.SERVER.getPhaseContext().getTransactor().logPlayerInventoryChange((Player)((net.minecraft.server.level.ServerPlayer)self), PlayerInventoryTransaction.EventCreator.STANDARD);
                    ((net.minecraft.server.level.ServerPlayer)self).inventoryMenu.broadcastChanges();
                }
            }
        }
    }

    @Inject(method={"stopUsingItem"}, at={@At(value="HEAD")})
    private void impl$onResetActiveHand(CallbackInfo ci) {
        if (this.level.isClientSide) {
            return;
        }
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy != null ? this.impl$activeItemStackCopy : this.useItem);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            this.impl$addSelfToFrame(frame, snapshot);
            SpongeCommon.post(SpongeEventFactory.createUseItemStackEventReset(PhaseTracker.getCauseStackManager().currentCause(), this.useItemRemaining, this.useItemRemaining, snapshot));
        }
        this.impl$activeItemStackCopy = null;
    }

    @Inject(method={"canBeSeenAsEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$makeVanishable(CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof VanishableBridge && this.bridge$isVanished() && this.bridge$isVanishPreventsTargeting()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"stopSleeping"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;clearSleepingPos()V")})
    private void impl$callFinishSleepingEvent(CallbackInfo ci) {
        if (this.level.isClientSide) {
            return;
        }
        Optional<BlockPos> sleepingPos = this.shadow$getSleepingPos();
        if (!sleepingPos.isPresent()) {
            return;
        }
        BlockSnapshot snapshot = ((ServerWorld)this.level).createSnapshot(sleepingPos.get().getX(), sleepingPos.get().getY(), sleepingPos.get().getZ());
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        ServerLocation loc = ServerLocation.of((ServerWorld)this.level, VecHelper.toVector3d(this.shadow$position()));
        Vector3d rot = ((Living)((Object)this)).rotation();
        SleepingEvent.Finish event = SpongeEventFactory.createSleepingEventFinish(currentCause, loc, loc, rot, rot, snapshot, (Living)((Object)this));
        Sponge.eventManager().post(event);
        this.shadow$clearSleepingPos();
        if (event.toLocation().world() != this.level) {
            throw new UnsupportedOperationException("World change is not supported here.");
        }
        this.shadow$setPos(event.toLocation().x(), event.toLocation().y(), event.toLocation().z());
        ((Living)((Object)this)).setRotation(event.toRotation());
    }
}

